package com.tykj.model_layer.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.entity.ExcelConfig;
import com.tykj.model_layer.excel.ExcelData;
import com.tykj.model_layer.service.ExcelLogService;
import com.tykj.model_layer.service.impl.ModelHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping("/excel")
@Api(tags = "excel接口")
public class ExcelController {
    @Autowired
    private ExcelData excelData;

    @ApiOperation("导入excel")
    @PostMapping("/import")
    public ResponseEntity importExcel(){
        //@RequestParam int id
        int id = 15;
        return excelData.getExcelData(id);

    }

    @ApiOperation("导入excel模板")
    @PostMapping("/template")
    public ResponseEntity importTemplate(@RequestBody MultipartFile template){
        Map<String, int[]> i = null;
        try {
            i = excelData.getIndenxMap(template);
        } catch (IOException e) {
            e.printStackTrace();
            return ResultUtil.failed("导入失败！");
        }
        if (i == null || i.isEmpty()) {
            return ResultUtil.failed("没有模板文件导入失败！");
        }else {
            return ResultUtil.success("", "导入成功！");
        }
    }

    @ApiOperation("导入预览")
    @PostMapping("/rule")
    public ResponseEntity importRule(){
        int num = 9;
        return excelData.compareRule(num, new ArrayList<>(), new ArrayList<>());
    }

    @ApiOperation("新增excel路径")
    @PostMapping("/path")
    public ResponseEntity savePath(@RequestParam String path, @RequestParam String rootPath){
        return excelData.savePath(path, rootPath);
    }

    @ApiOperation("查询路径")
    @PostMapping("/findPath")
    public ResponseEntity findPath(){
        return excelData.findPath();
    }

    @ApiOperation("查询进度百分比")
    @PostMapping("/precent")
    public ResponseEntity findPrecent(){
        return excelData.findPrecen();
    }

    @ApiOperation("查询预览结果")
    @PostMapping("/preview")
    public ResponseEntity findPreview(){
        return excelData.findPreview();
    }

}
