package com.tykj.model_layer.controller;

import com.tykj.model_layer.entity.Rule;
import com.tykj.model_layer.entity.vo.ExcelLogVo;
import com.tykj.model_layer.service.ExcelLogService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/log")
@Api(tags = "log接口")
public class ExcelLogController {
    @Autowired
    private ExcelLogService service;
    @ApiOperation("查询")
    @PostMapping("/page")
    public ResponseEntity delectRule(@RequestBody ExcelLogVo log){
        return service.pageAll(log);
    }
}
