package com.tykj.model_layer.controller;

import com.tykj.base.result.ApiException;
import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.entity.ColumnInfo;
import com.tykj.model_layer.entity.Quote;
import com.tykj.model_layer.entity.customEnums.ConnectionType;
import com.tykj.model_layer.entity.vo.QueryCondition;
import com.tykj.model_layer.entity.vo.SearchQuoteVO;
import com.tykj.model_layer.entity.vo.UpdateQuoteVO;
import com.tykj.model_layer.service.QuoteService;
import com.tykj.model_layer.service.impl.ModelImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.*;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/17 15:57
 */

@Api(tags = "引用接口")
@RestController
@RequestMapping("/quote")
public class QuoteController {
    @Autowired
    private QuoteService quoteService;

    @Autowired
    ModelImpl model;

    @Autowired
    ColumnInfoDao columnInfoDao;

    @ApiModelProperty("引用删除")
    @GetMapping("/delete")
    public ResponseEntity deleteQuote(Integer id) {
        return ResultUtil.success(quoteService.delQuote(id), "删除成功！");
    }

    @ApiModelProperty("引用更新")
    @PostMapping("/update")
    public ResponseEntity UpdateQuote(@RequestBody UpdateQuoteVO updateQuoteVO) {
        return ResultUtil.success(quoteService.updateQuote(updateQuoteVO), "查询成功！");
    }

    @ApiModelProperty("查找所有引用")
    @PostMapping("/getAllQuote")
    public ResponseEntity getAllQuote(@RequestBody SearchQuoteVO searchQuoteVO) {
        return ResultUtil.success(quoteService.getAllQuote(searchQuoteVO), "查询成功！");
    }

    @ApiModelProperty("查找所有引用如果没有引用的话就全部的值")
    @PostMapping("/getAllQuoteIf")
    public ResponseEntity getAllQuoteOr(@RequestBody SearchQuoteVO searchQuoteVO) {
        List<Quote> allQuote = quoteService.getAllQuote(searchQuoteVO);
        if (searchQuoteVO.getColumnIds().length!=1){
            throw new ApiException("查询字段补正确");
        }
        if (allQuote.size()<=0){
            Optional<ColumnInfo> byId = columnInfoDao.findById(searchQuoteVO.getColumnIds()[0]);
            ColumnInfo  columnInfo = byId.get();
            List diaoyan = model.complexQuery("diaoyan", Arrays.asList(columnInfo.getFieldName()), Arrays.asList(new QueryCondition(columnInfo.getFieldName(),"!=","null", ConnectionType.AND)), columnInfo.getFieldName());
            for (Object str : diaoyan) {
                allQuote.add(new Quote(searchQuoteVO.getColumnIds()[0],str+""));
            }
        }
        return ResultUtil.success(allQuote, "查询成功！");
    }


}
