package com.tykj.model_layer.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.entity.Rule;
import com.tykj.model_layer.entity.vo.RuleVo;
import com.tykj.model_layer.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/rule")
@Api(tags = "规则接口")
public class RuleController {
    @Autowired
    private RuleService ruleService;

    @ApiOperation("新增规则")
    @PostMapping("/save")
    public ResponseEntity saveRule(@RequestBody List<Rule> rules){
        return ruleService.saveRuleList(rules);
    }

    @ApiOperation("查询规则")
    @PostMapping("/findAll")
    public ResponseEntity findRule(){
        try {
            List<Rule> rules = ruleService.findAll();
            return ResultUtil.success(rules, "查询成功！");
        }catch (Exception e){
            return ResultUtil.failed("查询失败！");
        }

    }

    @ApiOperation("删除规则")
    @PostMapping("/delect")
    public ResponseEntity delectRule(@RequestBody List<Rule> rules){
        return ruleService.delectRuleList(rules);
    }

}
