package com.tykj.model_layer.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.dao.VersionDao;
import com.tykj.model_layer.entity.Version;
import com.tykj.model_layer.entity.vo.VersionVO;
import com.tykj.model_layer.service.VersionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/19 14:47
 */
@Api(tags = "版本接口")
@RestController
@RequestMapping("/version")
public class VersionController {
    @Autowired
    private VersionService versionService;

    @ApiOperation(value = "删除版本")
    @DeleteMapping("/delVersion")
    public ResponseEntity delVersion(Integer id){
        versionService.delVersion(id);
    return ResultUtil.success("删除成功！");
    }

    @ApiOperation(value = "新增版本")
    @PostMapping("/addVersion")
    public ResponseEntity addVersion(@RequestBody VersionVO versionVO){
        return ResultUtil.success(versionService.addVersion(versionVO),"保存成功！");
    }

    @ApiOperation(value = "回滚版本")
    @PostMapping("/goBack")
    public ResponseEntity goBack(Integer id){
        versionService.goback(id);
        return ResultUtil.success("还原成功了");
    }

    @ApiOperation(value = "根据DBId查询版本")
    @GetMapping("/getVersionList")
    public ResponseEntity getVersionList(Integer dbId){
        return ResultUtil.success(versionService.findVersionByDbId(dbId),"查询成功");
    }
}
