package com.tykj.model_layer.dao;



import com.tykj.model_layer.entity.ColumnInfo;


import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @ClassName ColumnInfoDao
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:22
 * @Version 1.0
 */
public interface ColumnInfoDao extends JpaRepository<ColumnInfo, Integer>, JpaSpecificationExecutor<ColumnInfo> {
    /**
     * 根据dbId查询所有
     * @param id
     * @return
     */
    List<ColumnInfo> findAllByDbId(int id);

    /**
     * 根据dbID删除
     * @param id
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    void deleteAllByDbId(Integer id);
}
