package com.tykj.model_layer.dao;

import com.tykj.model_layer.entity.Version;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/19 13:21
 */
public interface VersionDao  extends JpaRepository<Version,Integer>, JpaSpecificationExecutor<Version> {

    List<Version> findAllByDbId(Integer dbId);

    /**
     * 将所有该DBID的列都设为非当前版本
     * @param dbId
     * @return
     */
    @Modifying
    @Transactional
    @Query(value = "update Version v set v.currentVersionFlag=0 where v.dbId=:dbId ")
    int updateVersionToNotCurrent(@Param("dbId") Integer dbId);

}
