package com.tykj.model_layer.entity;


import com.tykj.base.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * @ClassName ColumnInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:14
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@Entity
@Table
@ApiModel("列对象")
public class ColumnInfo extends BaseEntity {

    /**
     * 是否primary key， 0是，1否
     */
    @ApiModelProperty("是否主键")
    private Integer primaryKey;

    @ApiModelProperty("列名")
    private String fieldName;

    @ApiModelProperty("列名中文描述")
    private String fieldTitle;
    @ApiModelProperty("列类型")
    private String fieldType;
    @ApiModelProperty("长度")
    private Integer fieldLength;
    @ApiModelProperty("所属表名")
    private String dbName;
    @ApiModelProperty("所属表id")
    private Integer dbId;
    @ApiModelProperty("详细描述")
    private String description;

    @ApiModelProperty("引用对象")
    @Transient
    private List<Quote> quoteList;

    public ColumnInfo(Integer primaryKey, String fieldName, String fieldTitle, String fieldType, Integer fieldLength, String dbName, Integer dbId, String description) {
        this.primaryKey = primaryKey;
        this.fieldName = fieldName;
        this.fieldTitle = fieldTitle;
        this.fieldType = fieldType;
        this.fieldLength = fieldLength;
        this.dbName = dbName;
        this.dbId = dbId;
        this.description = description;
    }
}
