package com.tykj.model_layer.entity;

import com.tykj.base.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
@Table
@ApiModel("规则表")
public class Rule extends BaseEntity {
    @ApiModelProperty("规则key，不能为空")
    private String ruleKey;
    @ApiModelProperty("key中文")
    private String name;
    @ApiModelProperty("key数据类型")
    private String type;
    @ApiModelProperty("规则")
    private String rule;
    @ApiModelProperty("等级，1 返回修改，2 直接删除")
    private String level;
    @ApiModelProperty("对比结果")
    private String result;
    @ApiModelProperty("是否需要对比多个sheet数据, 0不用，1需要对比所有sheet的name是否相同，2 唯一值")
    private Integer compare;
}
