package com.tykj.model_layer.entity;



import com.tykj.base.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @ClassName TableInfo
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/24 11:05
 * @Version 1.0
 */

@Entity
@Table
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("表对象")
public class TableInfo extends BaseEntity {


    @ApiModelProperty("数据对象名，不能为空")
    @Column(nullable = false)
    private String modelName;

    @ApiModelProperty("表中文名，不能为空")
    @Column(nullable = false)
    private String modelTitle;

    @ApiModelProperty("详细描述")
    private String description;

    /**
     *0是扫描，1是自建，2基础对象转变的业务对象
     */
    @ApiModelProperty("建表类型")
    private Integer modelType;

    @ApiModelProperty("执行人（保留字段）")
    private String reviser;
    @ApiModelProperty("父表名称")
    private String parentTable;

    /**
     * 聚合对象主表id
     */
    @ApiModelProperty("主表id")
    private Integer mainTableId;

    @Lob
    @ApiModelProperty("表对应hbm.xml")
    private String xml;

    @ApiModelProperty("备份表")
    private String backName;

    @Lob
    @ApiModelProperty("备份表XML")
    private String backXml;

}
