package com.tykj.model_layer.entity.vo;

import com.tykj.model_layer.entity.customEnums.ConnectionType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author HASEE
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("复杂查询")
public class QueryCondition {

    /**
     * 字段名 例如:age
     */
    @ApiModelProperty(value = "查询字段名",example = "age")
    private String name;

    /**
     * 条件符号类型 例如:>
     */
    @ApiModelProperty(value = "查询条件符号类型",example = ">")
    private String type;

    /**
     * 条件参数值 例如:20
     */
    @ApiModelProperty(value = "条件参数值",example = "18")
    private String value;

    @ApiModelProperty(value = "连接条件",example = "or或者and")
    private ConnectionType connectionType;

}
