package com.tykj.model_layer.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.tykj.base.result.ApiException;
import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.dao.ExcelConfigDao;
import com.tykj.model_layer.entity.ExcelConfig;
import com.tykj.model_layer.entity.ExcelLog;
import com.tykj.model_layer.entity.Quote;
import com.tykj.model_layer.entity.Rule;
import com.tykj.model_layer.entity.vo.ExcelErrorVo;
import com.tykj.model_layer.entity.vo.ExcelVo;
import com.tykj.model_layer.entity.vo.QueryCondition;
import com.tykj.model_layer.service.ExcelLogService;
import com.tykj.model_layer.service.ModelService;
import com.tykj.model_layer.service.RuleService;
import com.tykj.model_layer.service.impl.ModelHelper;
import io.swagger.models.auth.In;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Component
public class ExcelData {
    @Autowired
    private ModelService modelService;
    @Autowired
    private ModelHelper modelHelper;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private ExcelLogService excelLogService;
    @Autowired
    private ExcelConfigDao excelConfigDao;
    private String path;
    private String rootPath;
    private float percent;
    private String tmpPath;
    private ExcelVo previewResult;

    public ExcelData(){

    }

    public ResponseEntity getExcelData(int id){
        String successPath = rootPath + "/research/successFile/";
        String errorPath = rootPath + "/research/errorFile/";
        File success = new File(successPath);
        File error = new File(errorPath);
        if (!success.exists()){
            success.mkdirs();
        }
        if (!error.exists()){
            error.mkdirs();
        }

        this.percent =0;//百分比数字
        String jsonData = modelHelper.getJsonExpample(id);
        try {
            //{className={propertyName=""}}
            Map<String, Map<String, Object>> dataMap = JSON.parseObject(jsonData,
                    new TypeReference<Map<String, Map<String, Object>>>(){});

            List<File> dataFiles = new ArrayList<>();
            List<File> erroeFiles = new ArrayList<>();
            compareRule(1, dataFiles, erroeFiles);
            System.out.println(path);
            File[] successFile = new File(path).listFiles();
            int totalNum = successFile == null ? 0 : successFile.length;
//            File[] dataFiles = file.listFiles();
            if (dataFiles == null || dataFiles.size() == 0){
                excelLogService.save(new ExcelLog("导入失败", "文件路径下没有文件", ""));
                return ResultUtil.failed("没有待导入文件！");
            }

            //找到需要判断唯一值的规则
            List<Rule> ruleList = ruleService.findAll().stream().filter(rule1 -> rule1.getCompare() == 2).collect(Collectors.toList());
            List<String> ruleKeyList = ruleList.stream().map(Rule::getRuleKey).collect(Collectors.toList());

            String successFileNameList = "";
            String errorFileNameList = "";
            String errorReason = "";
            int total = 0;//操作完成的总数量
            int successNum = 0;
            int errorNum = 0;
            for (File file1 : erroeFiles){
                file1.renameTo(new File(errorPath + file1.getName()));
            }
            for (File dataFile : dataFiles){
                //传给保存接口的list
                List<Map<String, Object>> saveMapList = new ArrayList<>();
                String fileName = dataFile.getName();
                try {
                    //取模板,如果有模板文件传过来就解析模板文件并保存，否则就读本地模板
                    Template template = new Template();
                    String tem = template.getTemplate("template.txt");
                    Map<String, int[]> indexMap = JSON.parseObject(tem, new TypeReference<Map<String, int[]>>(){});
                    if (indexMap.isEmpty()){
                        excelLogService.save(new ExcelLog("导入失败", "没有模板文件", ""));
                        return ResultUtil.failed("没有模板文件导入失败！");
                    }
                    String remarkTemplateString = template.getTemplate("remarksTemplate.txt");
                    List<ExcelRemarks> remarksTemplateList = JSON.parseObject(remarkTemplateString, new TypeReference<List<ExcelRemarks>>(){});
                    //取数据
                    FileInputStream dataFis = new FileInputStream(dataFile);
                    Workbook dataWb = null;
                    if(fileName.endsWith("xls")) {
                        dataWb = new HSSFWorkbook(dataFis);
                    } else if(fileName.endsWith("xlsx")) {
                        dataWb = new XSSFWorkbook(dataFis);
                    }else {
                        errorFileNameList = errorFileNameList + "[" + fileName + "]";
                        errorReason = "不是excel文件或保存失败";
                        dataFile.renameTo(new File(errorPath + fileName));
                        continue;
                    }
                    for (int i = 0; i < dataWb.getNumberOfSheets(); i++){
                        Sheet sheet1 = dataWb.getSheetAt(i);
                        if (sheet1 == null || "引用表（请勿改动）".equals(sheet1.getSheetName())){
                            continue;
                        }
                        Map<String, Object> propertyNameAndData = new HashMap<>();
                        String className = null;
                        //取模板位置数据
                        for (String key : indexMap.keySet()){
                            int[] value = indexMap.get(key);
                            int dataRow = value[0];
                            int dataCell = value[1];
                            //key=className.propertyName
                            String[] classArray = key.split("[.]");
                            className = classArray[0];
                            Row row = sheet1.getRow(dataRow);
                            row.getCell(dataCell).setCellType(CellType.STRING);
                            if (dataMap.get(className) != null && dataMap.get(className).keySet().contains(classArray[1])){
                                propertyNameAndData.put(classArray[1], row.getCell(dataCell).getStringCellValue());
                            }
                            if (ruleKeyList.contains(key)){
                                //查询数据库是否有相同网络名称，有就更新
                                List<QueryCondition> queryConditions = new ArrayList<>();
                                QueryCondition queryCondition = new QueryCondition();
                                queryCondition.setName(classArray[1]);
                                queryCondition.setType("=");
                                queryCondition.setValue(row.getCell(dataCell).getStringCellValue());
                                queryConditions.add(queryCondition);
                                List<Map<String, Object>> list = modelService.complexQuery(className, null, queryConditions,null);
                                if (list != null && list.size() > 0){
                                    Object object = list.get(0).get("id");
                                    propertyNameAndData.put("id", object);
                                }
                            }
                        }
                        //取备注模板数据，并判断是否需要替换原数据
                        for (ExcelRemarks remark : remarksTemplateList){
                            int[] value = remark.getLocation();
                            int dataRow = value[0];
                            int dataCell = value[1];
                            Row row = sheet1.getRow(dataRow);
                            row.getCell(dataCell).setCellType(CellType.STRING);
                            String[] classArray = remark.getClassName().split("[.]");
                            Object templateData = propertyNameAndData.get(classArray[1]);
                            if (String.valueOf(templateData).contains(remark.getRemark())){
                                String remarkData = row.getCell(dataCell).getStringCellValue();
                                if ("append".equals(remark.getType())){
                                    Object temData = propertyNameAndData.get(classArray[1]) == null ? "" : propertyNameAndData.get(classArray[1]);
                                    remarkData = temData + remark.getJointMark() + remarkData;
                                    propertyNameAndData.put(classArray[1], remarkData);
                                }
                                propertyNameAndData.put(classArray[1], remarkData);
                            }
                        }
                        if (!propertyNameAndData.isEmpty()){
                            Map<String, Object> classNameAndDataMap = new HashMap<>();
                            classNameAndDataMap.put(className, propertyNameAndData);
                            System.out.println(classNameAndDataMap);
                            saveMapList.add(classNameAndDataMap);
                        }
                    }

                    int re = modelService.putValueByEntityNameList(saveMapList,false);
                    if (re == 0){
                        successFileNameList = successFileNameList + "[" + fileName + "]";
                        dataFile.renameTo(new File(successPath + fileName));
                        successNum = successNum +1;
                    }else {
                        errorFileNameList = errorFileNameList + "[" + fileName + "]";
                        errorReason = "不是excel文件或保存失败";
                        dataFile.renameTo(new File(errorPath + fileName));
                        errorNum = errorNum + 1;
                    }
                    total = total + 1;
                    this.percent = (float)total/dataFiles.size();
                }catch (Exception e){
                    e.printStackTrace();
                    errorFileNameList = errorFileNameList + "[" + fileName + "]";
                    continue;
                }

            }


            System.out.println(successPath);
            System.out.println(errorPath);
            errorNum = errorNum + erroeFiles.size();
            ExcelVo excelVo = new ExcelVo(totalNum, successNum, errorNum, 0, new Date(),null);
            if (!"".equals(errorFileNameList)){
                excelLogService.save(new ExcelLog("导入失败", errorReason, errorFileNameList));
                String s = "导入失败";
                if (!"".equals(successFileNameList)){
                    s = "部分文件导入失败，" + successFileNameList + "导入成功";
                }
                return ResultUtil.failed(s);
            }else {
                excelLogService.save(new ExcelLog("导入成功", "", successFileNameList));
                return ResultUtil.success(excelVo, "导入成功！");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        excelLogService.save(new ExcelLog("导入失败", "", ""));
        return ResultUtil.failed("导入失败！");
    }

    /**
     * 预览
     * @return
     */
    public ResponseEntity compareRule(int num, List<File> resultFiles, List<File> errorFiles){
        this.percent = 0;
        this.previewResult = null;
        if (path == null || rootPath == null){
            path = findPaths().getPath();
            rootPath = findPaths().getRootPath();
            if (path ==null){
                return ResultUtil.failed("没有配置导入路径！");
            }
            if (rootPath == null){
                rootPath = System.getProperty("user.dir") + "/";
            }
            File rootFile = new File(rootPath);
            rootFile.mkdirs();
        }
        tmpPath = rootPath + "/research/tmp/";
        File tmp = new File(tmpPath);
        if (!tmp.exists()){
            tmp.mkdirs();
        }

        List<ExcelErrorVo> excelVos = new ArrayList<>();
        List<Rule> rules = ruleService.findAll();
        int total = 0;//总文件数量
        boolean isSuccess = true;
        try {
            Template template = new Template();
            String tem = template.getTemplate("template.txt");
            Map<String, int[]> indexMap = JSON.parseObject(tem, new TypeReference<Map<String, int[]>>(){});
            if (indexMap.isEmpty()){
                return ResultUtil.failed("没有excle模板,请导入模板文件！");
            }

            File file = new File(path);
            File[] dataFiles = file.listFiles();
            if (dataFiles == null || dataFiles.length == 0){
                this.percent = 1;
                return ResultUtil.success(new ExcelVo(), "空文件夹");
            }
            total = dataFiles.length;

            //用于判断excel内容是否符合选项
            String className = null;
            for (String key : indexMap.keySet()){
                className = key.split("[.]")[0];
                break;
            }
            //取所有字段的引用map<字段名,引用列表>
            Map<String, List<Quote>> he = modelHelper.getQuoteList(className);
            for (File dataFile : dataFiles){
                String fileName = dataFile.getName();
                isSuccess = true;//判断该文件是否全部符合规则
                String tel = null;//联系方式
                String unitName = null;//联系方式
                String buildTel = null;//承建单位
                List<String> result = new ArrayList<>();
                try {

                    FileInputStream dataFis = new FileInputStream(dataFile);
                    Workbook wb = null;

                    if(fileName.endsWith("xls")) {
                        wb = new HSSFWorkbook(dataFis);
                    } else if(fileName.endsWith("xlsx")) {
                        wb = new XSSFWorkbook(dataFis);
                    }
                    //{别名=数据}
                    Map<String, List<String>> ruleNameAndDataList = new HashMap<>();
                    Map<String, List<String>> ruleNameAndSheetNameList = new HashMap<>();
                    Map<String, String> sheetNameAndContent = new HashMap<>();
                    Map<String, String> networkNameAndSheetName = new HashMap<>();
                    for (int i = 0; i < wb.getNumberOfSheets(); i++){

                        Sheet sheet1 = wb.getSheetAt(i);
                        if ("引用表（请勿改动）".equals(sheet1.getSheetName()) || sheet1 ==null){
                            continue;
                        }
                        String sameNetSheetName = null;//网络名称sheet
                        String sameNetName = "";//网络名称别名
                        Row row = null;
                        for (String key : indexMap.keySet()){
                            if (result.size() > num){
                                break;
                            }
                            //key=className.property，从模板文件中取该字段的位置
                            int[] value = indexMap.get(key);
                            int dataRow = value[0];
                            int dataCell = value[1];
                            row = sheet1.getRow(dataRow);
                            row.getCell(dataCell).setCellType(CellType.STRING);
                            String data = row.getCell(dataCell).getStringCellValue();

                            // 取单位名字、联系方式、承建单位联系方式
                            if ("diaoyan.unit_contact".equals(key) && tel == null){
                                tel = data;
                            }
                            if ("diaoyan.contractor_contact_information".equals(key) && buildTel == null){
                                buildTel = data;
                            }
                            if ("diaoyan.name_of_user".equals(key) && unitName == null){
                                unitName = data;
                            }
                            //判断是否是两个相同的sheet，数据准备
                            if (sheetNameAndContent.get(sheet1.getSheetName()) == null || sheetNameAndContent.get(sheet1.getSheetName()).isEmpty()) {
                                sheetNameAndContent.put(sheet1.getSheetName(), data);
                            } else {
                                String con = sheetNameAndContent.get(sheet1.getSheetName());
                                sheetNameAndContent.put(sheet1.getSheetName(), con + data);
                            }
                            //判断引用是否符合规则
                            String propertyName = key.split("[.]")[1];
                            List<Quote> quotes = he.get(propertyName);
                            if (quotes != null && quotes.size() > 0){
                                boolean isQuote = true;
                                for (Quote quote : quotes){
                                    if(Objects.equals(data, quote.getValue())){
                                        isQuote = false;
                                        break;
                                    }
                                }
                                if (isQuote){
                                    int k = result.size() + 1;
                                    result.add(k + ".\"" + sheet1.getSheetName() + "\"第" + (dataRow + 1) + "行第" + (dataCell + 1) + "列不符合规则");
                                    isSuccess = false;
                                }
                            }
                            //正则规则判断
                            List<Rule> ruleList = rules.stream().filter(rule1 -> rule1.getRuleKey().equals(key)).collect(Collectors.toList());
                            if (!ruleList.isEmpty()) {
                                Rule rule = ruleList.get(0);
                                //判断同一个文件里所有sheet中该字段是否相同，数据准备
                                if (rule.getCompare() == 1) {
                                    if (ruleNameAndDataList.get(rule.getName())== null || ruleNameAndDataList.get(rule.getName()).isEmpty()) {
                                        List<String> list = new ArrayList<>();
                                        list.add(data);
                                        List<String> list1 = new ArrayList<>();
                                        list1.add(sheet1.getSheetName());
                                        ruleNameAndDataList.put(rule.getName(), list);
                                        ruleNameAndSheetNameList.put(rule.getName(), list1);
                                    } else {
                                        if (!ruleNameAndDataList.get(rule.getName()).contains(data)){
                                            ruleNameAndDataList.get(rule.getName()).add(data);
                                            ruleNameAndSheetNameList.get(rule.getName()).add(sheet1.getSheetName());
                                        }
                                    }
                                }else if (rule.getCompare() == 2){
                                    //判断统一文件中该字段是否唯一，网络名称是否唯一，数据准备
                                    if (networkNameAndSheetName.keySet().contains(data)) {
                                        sameNetSheetName = networkNameAndSheetName.get(data);//网络名称相同的sheetName
                                    }
                                    sameNetName = rule.getName();//别名
                                    networkNameAndSheetName.put(data, sheet1.getSheetName());
                                }
                                //正则判断
                                Pattern p = Pattern.compile(rule.getRule());
                                Matcher m = p.matcher(data);
                                if (!m.matches()) {
                                    //不符合
                                    int k = result.size() + 1;
                                    result.add(k + ".\"" + sheet1.getSheetName() + "\"第" + (dataRow + 1) + "行第" + (dataCell + 1) + "列不符合规则");
                                    isSuccess = false;
                                }

                            }

                        }
                        //判断网络名字是否一样
                        if (sameNetSheetName != null){
                            String now = sheetNameAndContent.get(sheet1.getSheetName());
                            String last = sheetNameAndContent.get(sameNetSheetName);
                            int k = result.size() + 1;
                            if (Objects.equals(now, last)){
                                result.add(k + ".\"" + sameNetSheetName + "\"与\"" + sheet1.getSheetName() + "\"存在内容相同表");
                            }else {
                                result.add(k + ".\"" + sameNetSheetName + "\"与\"" + sheet1.getSheetName() + "\"的\"" + sameNetName + "\"重名");
                            }
                            isSuccess = false;
                        }
                    }
                    //判断所有sheet ruleName的数据是否一样
                    if (!ruleNameAndDataList.isEmpty()){
                        for (String key : ruleNameAndDataList.keySet()){
                            List<String> list = ruleNameAndSheetNameList.get(key);
                            if (ruleNameAndDataList.get(key).size() > 1){
                                String sheetName = "";
                                for (String s : list){
                                    sheetName = sheetName + "\"" + s + "\"";
                                }
                                //不是全部相同
                                int k = result.size() + 1;
                                result.add(k + "." + sheetName + "中的\"" + key + "\"不同");
                                isSuccess = false;
                            }
                        }
                    }
                    if (isSuccess){
                        resultFiles.add(dataFile);
                    }else {
                        excelVos.add(new ExcelErrorVo(fileName, unitName, tel, buildTel, result));
                        errorFiles.add(dataFile);
                    }

                }catch (Exception e){
                    int k = result.size() + 1;
                    result.add(k + "." + "不是模板文件或读文件失败");
                    excelVos.add(new ExcelErrorVo(fileName, unitName, tel, buildTel, result));
                    errorFiles.add(dataFile);
                }
                if (num != 1){
                    this.percent = (float) (resultFiles.size() + errorFiles.size())/dataFiles.length;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return ResultUtil.failed("预览失败！");
        }
        ExcelVo excelVo = new ExcelVo(total,resultFiles.size(), errorFiles.size(), 0, new Date(), excelVos);
        this.previewResult = excelVo;
        return ResultUtil.success(excelVo, "预览成功");
    }

    /**
     * 读取模板文件
     * @param file 前端传过来的模板文件，如果没有传就读本地文件
     * @return
     */
    public Map<String, int[]> getIndenxMap(MultipartFile file) throws IOException {
        Map<String, int[]> indexMap = new HashMap<>();
        List<ExcelRemarks> remarksList = new ArrayList<>();
        if (file != null){
            String fileName = file.getResource().getFilename();
            InputStream fis = null;
            fis = file.getInputStream();
            Workbook wb = null;
            if(fileName.endsWith("xls")) {
                wb = new HSSFWorkbook(fis);
            } else if(fileName.endsWith("xlsx")) {
                wb = new XSSFWorkbook(fis);
            }
            Sheet sheet = wb.getSheetAt(0);
            Row row = null;
            int lastRow = sheet.getLastRowNum();
            for (int index = 0; index <= lastRow; index++){
                row = sheet.getRow(index);
                for(int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                    row.getCell(i).setCellType(CellType.STRING);
                    String data = row.getCell(i).getStringCellValue();
                    if (row.getCell(i) != null && data.contains("$")) {

                        int[] idenx = new int[2];
                        idenx[0] = row.getRowNum();
                        idenx[1] = i;
                        String type = null;
                        if (data.contains("*")){
                            //备注内容,data=$A.name*备注*insert*其他
                            String[] re = data.split("[*]");
                            if (re.length > 3){
                                type = re[0].substring(1);
                                remarksList.add(new ExcelRemarks(type, re[1], re[2], re[3], idenx));
                            }

                        }else {
                            //{className.propertyName=[1,2]},data=$A.name
                            type =  data.substring(1);
                            indexMap.put(type.trim(), idenx);
                        }

                    }
                }
            }
            Template template = new Template();
            template.saveTemplate(JSON.toJSONString(indexMap), "template.txt");
            template.saveTemplate(JSON.toJSONString(remarksList), "remarksTemplate.txt");

        }
//        else {
//            Template template = new Template();
//            String tem = template.getTemplate();
//            if (tem.isEmpty()){
//                return indexMap;
//            }
//            indexMap = JSON.parseObject(tem, new TypeReference<Map<String, int[]>>(){});
//        }
        return indexMap;

    }

    public ResponseEntity findPath(){
        try {
            return ResultUtil.success(findPaths(), "查询成功");
        }catch (Exception e){
            e.printStackTrace();
        }
        return ResultUtil.failed("查询失败");
    }
    public ResponseEntity savePath(String path, String rootPath){
        try {
            this.path = path;
            this.rootPath = rootPath;
            List<ExcelConfig> excelConfigs = excelConfigDao.findAll();
            ExcelConfig excelConfig = new ExcelConfig();
            if (excelConfigs != null && excelConfigs.size() > 0){
                excelConfig = excelConfigs.get(0);
            }
            excelConfig.setPath(path);
            excelConfig.setRootPath(rootPath);
            excelConfigDao.saveAndFlush(excelConfig);
            return ResultUtil.success("","保存成功");
        }catch (Exception e){
            e.printStackTrace();
        }
        return ResultUtil.failed("新增失败");
    }
    private ExcelConfig findPaths(){
        List<ExcelConfig> excelConfigs = excelConfigDao.findAll();
        if (excelConfigs != null && excelConfigs.size() > 0){
            return excelConfigs.get(0);
        }
        return new ExcelConfig();
    }

    public ResponseEntity findPrecen(){

        DecimalFormat df=new DecimalFormat("0");//设置保留位数
        String s = df.format(this.percent * 100);
        System.out.println("=============================================");
        System.out.println(s);
        if ("100".equals(s)){
            this.percent = 0;
        }
        return ResultUtil.success(s,"查询成功");
    }

    public ResponseEntity findPreview(){
        return ResultUtil.success(previewResult,"查询成功");
    }

}
