package com.tykj.model_layer.excel;

import java.io.*;
import java.util.Properties;

public class Template {
    /**
     * 把模板数据保存在txt文件中
     * @param data 模板json数据;{className.propertyName:[1,2]}
     *             key为类名.属性名，value为该属性在模板excel中的位置[行，列]
     */
    public void saveTemplate(String data, String fileName){
        String path = System.getProperty("user.dir") + "/" + fileName;
        Properties properties = new Properties();
        try {
            System.out.println(path);
            File writeName = new File(path); // 相对路径，如果没有则要建立一个新的output.txt文件
            if(!writeName.exists()) {
                writeName.createNewFile(); // 创建新文件,有同名的文件的话直接覆盖
            }
            FileWriter writer = new FileWriter(writeName);
            BufferedWriter out = new BufferedWriter(writer);
            out.write(data);
            out.flush(); // 把缓存区内容压入文件
            out.close();
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 前端没有传模板的时候，读取本地模板
     * @return
     */
    public String getTemplate(String fileName){
        String pathname  = System.getProperty("user.dir") + "/" + fileName;
        try{
            String result = "";
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try{
                fileReader = new FileReader(pathname);
                bufferedReader = new BufferedReader(fileReader);
                try{
                    String read = null;
                    while((read = bufferedReader.readLine()) != null){
//                       result = result + read+"\r\n";
                        result = result + read;
                    }
                }catch(Exception e){
                    e.printStackTrace();
                }
            }catch(Exception e){
                e.printStackTrace();
            }finally{
                if(bufferedReader != null){
                    bufferedReader.close();
                }
                if(fileReader != null){
                    fileReader.close();
                }
            }
//            System.out.println("读取出来的文件内容是："+"\r\n"+result);
            return result;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }

    }
}
