package com.tykj.model_layer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.base.page.JpaCustomOrder;
import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.dao.ExcelLogDao;
import com.tykj.model_layer.entity.ExcelLog;
import com.tykj.model_layer.entity.vo.ExcelLogVo;
import com.tykj.model_layer.service.ExcelLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class ExcelLogServiceImpl implements ExcelLogService {
    @Autowired
    ExcelLogDao excelLogDao;
    @Override
    public void save(ExcelLog log) {
        excelLogDao.save(log);
    }

    @Override
    public ResponseEntity pageAll(ExcelLogVo ruleVo) {
        try {
            ruleVo.setPage(ruleVo.getPage() - 1);
            PredicateBuilder<ExcelLog> and = Specifications.and();
            List<JpaCustomOrder> orders = new ArrayList<>();
            JpaCustomOrder jpaCustomOrder = new JpaCustomOrder();
            jpaCustomOrder.setCoulmn("createdTime");
            jpaCustomOrder.setDirection(Sort.Direction.DESC);
            orders.add(jpaCustomOrder);
            ruleVo.setOrders(orders);
            Page<ExcelLog> rules = excelLogDao.findAll(and.build(), ruleVo.getPageable());
            return ResultUtil.success(rules, "查询成功！");
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.failed("查询失败！");
        }
    }
}
