package com.tykj.model_layer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.base.result.ApiException;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.dao.QuoteDao;
import com.tykj.model_layer.entity.Quote;
import com.tykj.model_layer.entity.TableInfo;
import com.tykj.model_layer.entity.vo.SearchQuoteVO;
import com.tykj.model_layer.entity.vo.UpdateQuoteVO;
import com.tykj.model_layer.service.QuoteService;


import org.apache.commons.lang3.StringUtils;
import org.hibernate.sql.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;



import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/17 15:59
 */
@Service
public class QuoteServiceImpl implements QuoteService {
    @Autowired
    private QuoteDao quoteDao;


    @Override
    public  List<Quote> updateQuote(UpdateQuoteVO updateQuoteVO) {
        List<Quote> quoteList = updateQuoteVO.getQuoteList();
        for (Quote quote : quoteList) {
            quote.setColumnId(updateQuoteVO.getId());
            quoteDao.save(quote);
        }
        return null;
    }

    @Override
    public List<Quote> getAllQuote(SearchQuoteVO searchQuoteVO) {
        PredicateBuilder<Quote> and = Specifications.and();
        if (searchQuoteVO!=null){
            and.like(searchQuoteVO.getValue() != null && StringUtils.isNotEmpty(searchQuoteVO.getValue()),
                    "value", "%" + searchQuoteVO.getValue() + "%");
            and.in(searchQuoteVO.getColumnIds()!=null && searchQuoteVO.getColumnIds().length>0,
                    "columnId",searchQuoteVO.getColumnIds());
            and.in(searchQuoteVO.getValues()!=null && searchQuoteVO.getValues().length>0,
                    "value", searchQuoteVO.getValues());
        }
        return quoteDao.findAll(and.build());
    }


    @Override
    public Quote saveQuote(Quote quote) {
        if (existValue(quote.getColumnId(), quote.getValue())) {
            return quoteDao.save(quote);
        }
        throw new ApiException("插入错误！");
    }

    @Override
    public Integer delQuote(Integer id) {
         quoteDao.deleteById(id);
         return 1;
    }

    public boolean existValue(Integer cId, String value) {
        List<String> collect = quoteDao.findAllByColumnId(cId)
                .stream()
                .map(Quote::getValue)
                .collect(Collectors.toList());
        if (collect.contains(value)) {
            return true;
        }
        return false;
    }


}
