package com.tykj.model_layer.service.impl;

import com.github.wenhao.jpa.PredicateBuilder;
import com.github.wenhao.jpa.Specifications;
import com.tykj.base.result.ResultUtil;
import com.tykj.model_layer.dao.RuleDao;
import com.tykj.model_layer.entity.Rule;
import com.tykj.model_layer.entity.vo.RuleVo;
import com.tykj.model_layer.service.RuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.List;
@Service
public class RuleServiceImpl implements RuleService {
    @Autowired
    private RuleDao ruleDao;
    @Override
    public ResponseEntity saveRuleList(List<Rule> rules) {
        try {
            ruleDao.saveAll(rules);
            return ResultUtil.success("", "新增成功！");
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.failed("新增失败！");
        }
    }

    @Override
    public ResponseEntity pageAll(RuleVo ruleVo) {
        try {
            PredicateBuilder<Rule> and = Specifications.and();
            Page<Rule> rules = ruleDao.findAll(and.build(), ruleVo.getPageable());
            return ResultUtil.success(rules, "查询成功！");
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.failed("查询失败！");
        }
    }

    @Override
    public ResponseEntity delectRuleList(List<Rule> rules) {
        try {
            ruleDao.deleteAll(rules);
            return ResultUtil.success(rules, "删除成功！");
        }catch (Exception e){
            e.printStackTrace();
            return ResultUtil.failed("删除失败！");
        }
    }

    @Override
    public List<Rule> findAll() {
        return ruleDao.findAll();
    }
}
