package com.tykj.model_layer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.tykj.base.result.ApiException;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.dao.TableInfoDao;
import com.tykj.model_layer.dao.VersionDao;
import com.tykj.model_layer.entity.ColumnInfo;
import com.tykj.model_layer.entity.TableInfo;
import com.tykj.model_layer.entity.Version;
import com.tykj.model_layer.entity.vo.QueryCondition;
import com.tykj.model_layer.entity.vo.VersionVO;
import com.tykj.model_layer.service.VersionService;
import com.tykj.model_layer.utils.SessionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/19 13:57
 */
@Service
public class VersionServiceImpl implements VersionService {
    @Autowired
    VersionDao versionDao;

    @Autowired
    ColumnInfoDao columnInfoDao;

    @Autowired
    SessionUtil sessionUtil;

    @Autowired
    TableInfoDao tableInfoDao;

    @Autowired
    ModelImpl model;

    @Override
    public Version addVersion(VersionVO versionVO) {
        Version version = new Version();
        version.setVersionId(versionVO.getVersionId());
        version.setDbId(versionVO.getDbId());
        version.setVersionDesc(versionVO.getVersionDesc());
        TableInfo tableInfo = tableInfoDao.getOne(version.getDbId());
        List<Map<String, Object>> maps = model.complexQuery(tableInfo.getModelName(),null,null,null);
        List<Integer> collect = new ArrayList<>();
        for (Map<String, Object> map : maps) {
            collect.add((Integer) map.get("id"));
        }
        version.setIds(JSONArray.toJSONString(collect));
        versionDao.updateVersionToNotCurrent(version.getDbId());
        if (version.getCurrentVersionFlag()==null){
            version.setCurrentVersionFlag(1);
        }
        return versionDao.save(version);
    }

    @Override
    public List<Version> findVersionByDbId(Integer dbId){
        return versionDao.findAllByDbId(dbId);
    }

    @Override
    public void delVersion(Integer id) {
        versionDao.deleteById(id);
    }

    @Override
    public void goback(Integer id) {
        Optional<Version> byId = versionDao.findById(id);
        if (byId.isPresent()){
            Version version = byId.get();
            //生成回退前版本
            VersionVO versionVo = new VersionVO();
            versionVo.setVersionId("回退前版本");
            versionVo.setVersionDesc("回退前版本");
            versionVo.setDbId(version.getDbId());
            Version version1 = addVersion(versionVo);
            versionDao.save(version1);
            //回退
            TableInfo tableInfo = tableInfoDao.getOne(version.getDbId());
            Session session = sessionUtil.getSession();
            session.getTransaction().begin();

            String substring = version.getIds().substring(1, version.getIds().length() - 1);
            String[] split = substring.split(",");
            if (split.length>0){
                StringBuilder delete_Sql = new StringBuilder("delete ");
                delete_Sql.append(" from ").append(tableInfo.getModelName());
                delete_Sql.append(" where id in ("+substring+")");
                Query deleteQuery = session.createQuery(delete_Sql.toString());
                deleteQuery.executeUpdate();
            }

            StringBuilder selectSql = new StringBuilder("select ");
            selectSql.append("entity ");
            selectSql.append(" from ").append(tableInfo.getModelName()+"_back").append(" entity ");
            selectSql.append(" where id in ("+version.getIds().substring(1,version.getIds().length()-1)+")");

            Query query = session.createQuery(selectSql.toString());
            List<Map<String, Object>>  list = query.list();

            for (Map<String, Object> map : list) {
                map.remove("$type$");
                HashMap hashMap = new HashMap();
                hashMap.putAll(map);
                model.insertValue(tableInfo.getModelName(),hashMap,(SessionImpl) session,false,true,false);
            }
            versionDao.updateVersionToNotCurrent(version.getDbId());
            //将要回退的版本设为 当前版本
            version.setCurrentVersionFlag(1);
            versionDao.save(version);
            //回退前的版本设为 非当前版本
            System.out.println("1");
            session.getTransaction().commit();
            session.close();


        }else {
            throw new ApiException("版本不存在");
        }

    }


}
