package com.tykj.setting.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.setting.entity.vo.DisplaySettingVo;
import com.tykj.setting.service.DisplaySettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "展示设置相关接口")
@RequestMapping("/setting/display")
@RestController
public class DisplaySettingController {

    @Autowired
    private DisplaySettingService displaySettingService;

    @PostMapping
    @ApiOperation("保存展示设置")
    public ResponseEntity save(@RequestBody DisplaySettingVo displaySettingVo){
        displaySettingService.save(displaySettingVo);
        return ResultUtil.success("", "保存成功");
    }

    @GetMapping
    @ApiOperation("查找展示设置")
    public ResponseEntity find(){
        return ResultUtil.success(displaySettingService.find(),"查找成功");
    }

    @DeleteMapping
    @ApiOperation("删除展示设置")
    public ResponseEntity delete(){
        displaySettingService.delete();
        return ResultUtil.success("", "删除成功");
    }

}
