package com.tykj.setting.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.setting.entity.vo.GroupSettingVo;
import com.tykj.setting.service.GroupSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "分类设置相关接口")
@RequestMapping("/setting/group")
@RestController
public class GroupSettingController {

    @Autowired
    private GroupSettingService groupSettingService;

    @PostMapping
    @ApiOperation("新增分类设置")
    public ResponseEntity save(@RequestBody GroupSettingVo groupSettingVo){
        groupSettingService.save(groupSettingVo);
        return ResultUtil.success("", "保存成功");
    }

    @PutMapping
    @ApiOperation("更新分类设置")
    public ResponseEntity update(@RequestBody GroupSettingVo groupSettingVo){
        groupSettingService.update(groupSettingVo);
        return ResultUtil.success("", "更新成功");
    }

    @GetMapping
    @ApiOperation("查找所有分类设置")
    public ResponseEntity findAll(){
        return ResultUtil.success(groupSettingService.findAll(),"查找成功");
    }

    @GetMapping("/byId/{id}")
    @ApiOperation("按id查找单个分类设置")
    public ResponseEntity findById(@PathVariable Integer id){
        return ResultUtil.success(groupSettingService.findById(id),"查找成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("按id删除单个分类设置")
    public ResponseEntity deleteById(@PathVariable Integer id){
        groupSettingService.deleteById(id);
        return ResultUtil.success("", "删除成功");
    }


}
