package com.tykj.setting.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.setting.entity.vo.ScreenSettingVo;
import com.tykj.setting.service.ScreenSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "筛选设置相关接口")
@RequestMapping("/setting/screen")
@RestController
public class ScreenSettingController {


    @Autowired
    private ScreenSettingService screenSettingService;

    @PostMapping
    @ApiOperation("新增筛选设置")
    public ResponseEntity save(@RequestBody ScreenSettingVo screenSettingVo){
        screenSettingService.save(screenSettingVo);
        return ResultUtil.success("", "保存成功");
    }

    @PutMapping
    @ApiOperation("更新筛选设置")
    public ResponseEntity update(@RequestBody ScreenSettingVo screenSettingVo){
        screenSettingService.update(screenSettingVo);
        return ResultUtil.success("", "更新成功");
    }

    @GetMapping
    @ApiOperation("查找所有筛选设置")
    public ResponseEntity findAll(){
        return ResultUtil.success(screenSettingService.findAll(),"查找成功");
    }

    @GetMapping("/byId/{id}")
    @ApiOperation("按id查找单个筛选设置")
    public ResponseEntity findById(@PathVariable Integer id){
        return ResultUtil.success(screenSettingService.findById(id),"查找成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("按id删除单个筛选设置")
    public ResponseEntity deleteById(@PathVariable Integer id){
        screenSettingService.deleteById(id);
        return ResultUtil.success("", "删除成功");
    }

}
