package com.tykj.setting.controller;

import com.tykj.base.result.ResultUtil;
import com.tykj.setting.entity.vo.StatisticsSettingVo;
import com.tykj.setting.service.StatisticsSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "统计图设置相关接口")
@RequestMapping("/setting/statistics")
@RestController
public class StatisticsSettingController {

    @Autowired
    private StatisticsSettingService statisticsSettingService;

    @PostMapping
    @ApiOperation("新增统计图设置")
    public ResponseEntity save(@RequestBody StatisticsSettingVo statisticsSettingVo){
        statisticsSettingService.save(statisticsSettingVo);
        return ResultUtil.success("", "保存成功");
    }

    @PutMapping
    @ApiOperation("更新统计图设置")
    public ResponseEntity update(@RequestBody StatisticsSettingVo statisticsSettingVo){
        statisticsSettingService.update(statisticsSettingVo);
        return ResultUtil.success("", "更新成功");
    }

    @GetMapping
    @ApiOperation("查找所有统计图设置")
    public ResponseEntity findAll(){
        return ResultUtil.success(statisticsSettingService.findAll(),"查找成功");
    }

    @GetMapping("/limit/{limit}")
    @ApiOperation("指定数量查找序号前几个统计图设置 按序号排序")
    public ResponseEntity findLimit(@PathVariable Integer limit){
        return ResultUtil.success(statisticsSettingService.findByLimit(limit),"查找成功");
    }

    @GetMapping("/byId/{id}")
    @ApiOperation("按id查找单个统计图设置")
    public ResponseEntity findById(@PathVariable Integer id){
        return ResultUtil.success(statisticsSettingService.findById(id),"查找成功");
    }

    @DeleteMapping("/{id}")
    @ApiOperation("按id删除单个统计图设置")
    public ResponseEntity deleteById(@PathVariable Integer id){
        statisticsSettingService.deleteById(id);
        return ResultUtil.success("", "删除成功");
    }

}
