package com.tykj.setting.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tykj.model_layer.entity.customEnums.ConnectionType;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.persistence.*;

@Accessors(chain = true)
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class ConditionSetting {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("字段ID")
    private Integer columnId;

    @ApiModelProperty("操作符类型")
    private String type;

    @ApiModelProperty("对象值")
    private String value;

    @ApiModelProperty(value = "连接条件",example = "or或者and")
    private ConnectionType connectionType;

    @Transient
    private String columnName;

    @JsonIgnore
    private Integer screenSettingId;
}
