package com.tykj.setting.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class StatisticsSetting {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("名称 ")
    private String name;

    @ApiModelProperty("类型")
    private Integer type;

    @ApiModelProperty("序号")
    private Integer orderPos;

    @ApiModelProperty("参数内容 json格式")
    @Lob
    private String params;

}
