package com.tykj.setting.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.base.result.ApiException;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.entity.ColumnInfo;
import com.tykj.setting.entity.DisplaySetting;
import com.tykj.setting.entity.vo.ColumnInfoVo;
import com.tykj.setting.entity.vo.DisplaySettingVo;
import com.tykj.setting.repository.DisplaySettingRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class DisplaySettingService {

    @Autowired
    private DisplaySettingRepository displaySettingRepository;

    @Autowired
    ColumnInfoDao columnInfoDao;

    private final Integer id = 1;

    public void save(DisplaySettingVo groupSettingVo){
        String columnIds = "[]";
        try {
            columnIds = new ObjectMapper().writeValueAsString(groupSettingVo.getColumnIds());
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        DisplaySetting displaySetting = new DisplaySetting(id,groupSettingVo.getDbId(), columnIds);
        displaySettingRepository.save(displaySetting);
    }

    public DisplaySettingVo find(){
        Optional<DisplaySetting> byId = displaySettingRepository.findById(id);
        if (byId.isPresent()){
            DisplaySetting displaySetting = byId.get();
            List<Integer> columnIds = new ArrayList<>();
            try {
                columnIds = new ObjectMapper().readValue(displaySetting.getColumnIds(), new TypeReference<List<Integer>>() {
                });
            } catch (JsonProcessingException e) {
                e.printStackTrace();
            }
            List<ColumnInfoVo> columnString  = new ArrayList<>();
            for (Integer columnId : columnIds) {
                Optional<ColumnInfo> byId1 = columnInfoDao.findById(columnId);
                if (!byId1.isPresent()){
                    throw new ApiException("列ID："+columnId+"，不存在");
                }
                columnString.add(new ColumnInfoVo(byId1.get().getFieldName(),byId1.get().getFieldTitle()));
            }
            return new DisplaySettingVo(displaySetting.getId(),displaySetting.getDbId(),columnIds,columnString);
        } else {
            throw new RuntimeException("未找到该数据");
        }
    }

    public void delete(){
        displaySettingRepository.deleteById(id);
    }

}
