package com.tykj.setting.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.base.result.ApiException;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.entity.ColumnInfo;
import com.tykj.model_layer.entity.vo.GroupCondition;
import com.tykj.setting.entity.GroupSetting;
import com.tykj.setting.entity.vo.GroupSettingVo;
import com.tykj.setting.repository.GroupSettingRepository;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
public class GroupSettingService {

    @Autowired
    private GroupSettingRepository groupSettingRepository;

    @Autowired
    ColumnInfoDao columnInfoDao;

    public void save(GroupSettingVo groupSettingVo) {
        boolean newData = Objects.isNull(groupSettingVo.getId());
        if (newData) {
            GroupSetting groupSetting = groupSetting(groupSettingVo);
            groupSettingRepository.save(groupSetting);
        } else {
            throw new RuntimeException("新增数据不可附带id");
        }
    }

    public void update(GroupSettingVo groupSettingVo) {
        boolean exist = Objects.nonNull(groupSettingVo.getId()) && groupSettingRepository.existsById(groupSettingVo.getId());
        if (exist) {
            GroupSetting groupSetting = groupSetting(groupSettingVo);
            groupSettingRepository.save(groupSetting);
        } else {
            throw new RuntimeException("未找到该id的数据");
        }
    }

    public List<GroupSettingVo> findAll() {
        List<GroupSettingVo> collect = groupSettingRepository.findAll().stream()
                .map(this::groupSettingVo)

                .collect(Collectors.toList());
        collect.forEach(item->{

        });
        return collect;
    }

    public GroupSettingVo findById(Integer id) {
        GroupSettingVo groupSettingVo = groupSettingRepository.findById(id)
                .map(this::groupSettingVo)
                .orElseThrow(() -> new RuntimeException("未找到该id的数据"));
        Optional<ColumnInfo> byId = columnInfoDao.findById(groupSettingVo.getColumnId());
        if (!byId.isPresent()){
            throw new ApiException("列ID："+groupSettingVo.getColumnId()+"，不存在");
        }
        groupSettingVo.setColumnName(byId.get().getFieldName());
        return groupSettingVo;
    }

    public void deleteById(Integer id) {
        groupSettingRepository.deleteById(id);
    }


    private GroupSetting groupSetting(GroupSettingVo groupSettingVo){
        String groupConditions = "[]";
        try {
            groupConditions = new ObjectMapper().writeValueAsString(groupSettingVo.getGroupConditions());
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return new GroupSetting(
                groupSettingVo.getId(),
                groupSettingVo.getModelId(),
                groupSettingVo.getColumnId(),
                groupSettingVo.getName(),
                groupConditions
        );
    }

    private GroupSettingVo groupSettingVo(GroupSetting groupSetting){

        List<GroupCondition> groupConditions = new ArrayList<>();
        try {
            groupConditions = new ObjectMapper().readValue(groupSetting.getGroupConditions(), new TypeReference<List<GroupCondition>>() {
            });
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        String columnName = "";
        Optional<ColumnInfo> byId = columnInfoDao.findById(groupSetting.getColumnId());
        if (byId.isPresent()){
            columnName = byId.get().getFieldName();
        }


        return new GroupSettingVo(
                groupSetting.getId(),
                groupSetting.getModelId(),
                groupSetting.getColumnId(),
                groupSetting.getName(),
                columnName,
                groupConditions
        );
    }

}
