package com.tykj.setting.service;

import com.tykj.base.result.ApiException;
import com.tykj.model_layer.dao.ColumnInfoDao;
import com.tykj.model_layer.entity.ColumnInfo;
import com.tykj.setting.entity.ConditionSetting;
import com.tykj.setting.entity.ScreenSetting;
import com.tykj.setting.entity.vo.ScreenSettingVo;
import com.tykj.setting.repository.ConditionSettingRepository;
import com.tykj.setting.repository.ScreenSettingRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
public class ScreenSettingService {
    /**
     * 筛选设置
     */
    @Autowired
    private ScreenSettingRepository screenSettingRepository;
    /**
     * 筛选设置中的条件
     */
    @Autowired
    private ConditionSettingRepository conditionSettingRepository;

    @Autowired
    ColumnInfoDao columnInfoDao;


    public void save(ScreenSettingVo screenSettingVo){
        boolean newData = Objects.isNull(screenSettingVo.getId());
        if (newData){
            ScreenSetting saved = screenSettingRepository.save(new ScreenSetting(screenSettingVo.getId(),screenSettingVo.getTableInfoId(),screenSettingVo.getName()));
            Integer savedId = saved.getId();
            List<ConditionSetting> conditionsForSave = screenSettingVo.getConditions().stream()
                    .map(conditionSetting -> conditionSetting.setScreenSettingId(savedId))
                    .collect(Collectors.toList());
            conditionSettingRepository.saveAll(conditionsForSave);
        } else {
            throw new RuntimeException("新增数据不可附带id");
        }
    }

    public void update(ScreenSettingVo screenSettingVo){
        boolean exist = Objects.nonNull(screenSettingVo.getId()) && screenSettingRepository.existsById(screenSettingVo.getId());
        if (exist){
            conditionSettingRepository.deleteAllByScreenSettingId(screenSettingVo.getId());
            screenSettingRepository.save(new ScreenSetting(screenSettingVo.getId(),screenSettingVo.getTableInfoId(),screenSettingVo.getName()));
            Integer savedId = screenSettingVo.getId();
            List<ConditionSetting> conditionsForSave = screenSettingVo.getConditions().stream()
                    .map(conditionSetting -> conditionSetting.setScreenSettingId(savedId))
                    .collect(Collectors.toList());
            conditionSettingRepository.saveAll(conditionsForSave);
        } else {
            throw new RuntimeException("未找到该id的数据");
        }
    }

    public List<ScreenSettingVo> findAll(){
        return screenSettingRepository.findAll().stream()
                .map(this::screenSettingVo)
                .collect(Collectors.toList());
    }

    public ScreenSettingVo findById(Integer id){
        Optional<ScreenSetting> byId = screenSettingRepository.findById(id);
        if (byId.isPresent()){
            ScreenSetting screenSetting = byId.get();
            List<ConditionSetting> conditions = conditionSettingRepository.findAllByScreenSettingId(id);
            for (ConditionSetting condition : conditions) {
                Optional<ColumnInfo> byId1 = columnInfoDao.findById(condition.getColumnId());
                if (byId1.isPresent()){
                    condition.setColumnName(byId1.get().getFieldName());
                }else {
                    throw new ApiException("列ID："+condition.getColumnId()+"，不存在");
                }
            }
            return new ScreenSettingVo(screenSetting.getId(),screenSetting.getTableInfoId(),screenSetting.getName(),conditions
            );
        } else {
            throw new RuntimeException("未找到该id的数据");
        }
    }

    public void deleteById(Integer id){
        screenSettingRepository.deleteById(id);
    }


    private ScreenSettingVo screenSettingVo(ScreenSetting screenSetting){
        List<ConditionSetting> conditions = conditionSettingRepository.findAllByScreenSettingId(screenSetting.getId());
        for (ConditionSetting condition : conditions) {
            Optional<ColumnInfo> byId = columnInfoDao.findById(condition.getColumnId());
            if (byId.isPresent()){
                condition.setColumnName(byId.get().getFieldName());
            }else {
                throw new ApiException("列ID："+condition.getColumnId()+"，不存在");
            }
        }
        return new ScreenSettingVo(screenSetting.getId(),screenSetting.getTableInfoId(),screenSetting.getName(),conditions);
    }

}
