package com.tykj.datawarehouse.model.utils;

import com.tykj.datawarehouse.base.result.ApiException;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.regex.Pattern;

import static java.util.Objects.isNull;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/6/29 11:19
 */
public class CheckUtils {

    /**
     * 正则校验
     *
     * @param regx
     * @param val
     * @return
     */
    public static Boolean validationRule(String regx, String val) {
        //加入没有规则就默认不需要校验
        if (StringUtils.isNotEmpty(regx) || isNull(regx)) {
            return true;
        }
        //假如规则不为空，值为空默认通过校验
        if (!StringUtils.isEmpty(regx)) {
            if (StringUtils.isNotEmpty(val) || isNull(val)) {
                return true;
            } else {
                Pattern pattern = Pattern.compile(regx);
                return pattern.matcher(val).matches();
            }
        }
        throw new ApiException("校验不通过！");
    }

    public static Boolean validationQuote(List<String> quotes, String val) {
        //如果没有引用就通过
        if (quotes.size() == 0) {
            return true;
        }
        //如果引用存在则通过
        if (quotes.contains(val)) {
            return true;
        }
        throw new ApiException("引用不通过！");
    }


}
