package com.tykj.base.config;

import com.tykj.model.create_util.BaseTableUtil;
import com.tykj.model.create_util.MysqlTableUtil;
import com.tykj.model.create_util.OscarTableUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * @author huangjiafu
 * @version V1.0
 * @data 2021/7/15 10:46
 **/
@Configuration
public class BeanFactory {
    
    @Value("${spring.datasource.driver-class-name}")
    private String env;

    @Bean
    ClassLoader initClassLoader(){
        return getClass().getClassLoader();
    }

    @Bean("baseCreateUtil")
    BaseTableUtil baseCreateUtil() {
        if ("com.mysql.cj.jdbc.Driver".equals(env) || "com.mysql.jdbc.Driver".equals(env)) {
            return new MysqlTableUtil();
        }
        if ("com.oscar.Driver".equals(env)) {
            return new OscarTableUtil();
        }
        return new MysqlTableUtil();
    }
}
