package com.tykj.base.result;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class ResultMessage
 * @packageName com.example.hello.demo.resultObject
 **/
public class ResultUtil<T> {


    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity<ResultObj<T>> success(T data, String message) {
        return ResponseEntity.ok(new ResultObj<>(data,message));
    }
    /**
     * 成功返回结果
     */
    public static <T> ResponseEntity<ResultObj<T>> success(String message) {
        return ResponseEntity.ok(new ResultObj<>(null,message));
    }

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> ResponseEntity success(T data, HttpHeaders headers) {
        return new ResponseEntity(new ResultObj(data), headers, HttpStatus.OK);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity failed() {
        return ResponseEntity.status(500).body(new ResultObj("服务器内部发生错误"));
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity failed(T content) {
        return new ResponseEntity(new ResultObj(content), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity failed(HttpStatus httpStatus) {
        return new ResponseEntity(httpStatus);
    }

    /**
     * 失败返回结果
     */
    public static <T> ResponseEntity failed(HttpStatus httpStatus, T content) {
        return new ResponseEntity(new ResultObj(content), httpStatus);
    }

    /**
     * 参数验证失败返回结果
     */
    public static <T> ResponseEntity validateFailed(T content) {
        return failed(HttpStatus.INTERNAL_SERVER_ERROR, content);
    }


    /**
     * 未登录返回结果
     */
    public static <T> ResponseEntity unauthorized() {
        return failed(HttpStatus.UNAUTHORIZED);
    }

    /**
     * 未授权返回结果
     */
    public static <T> ResponseEntity forbidden() {
        return failed(HttpStatus.FORBIDDEN);
    }


}
