package com.tykj.model.create_util;

import com.tykj.base.result.ApiException;
import com.tykj.model.entity.vo.ColumnVO;
import com.tykj.model.entity.vo.TableVO;

import java.util.List;

/**
 * @author huangjiafu
 * @version V1.0
 * @data 2021/7/15 10:40
 **/
public abstract class  BaseCreateUtil {

    public String createTable(TableVO tableVO) {
        //   1sql-type="text" string 转为text文本，2长度超过会自动转换
        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName().toLowerCase().toUpperCase() + "\" table=\"" + tableVO.getModelName().toLowerCase().toUpperCase() + "\">\n";

        xmlMapping += addGenerator(tableVO);


        for (ColumnVO columnVO : dataList) {
            try {
                //由于ID属于自动建立的列 不允许用户自己建立
//                if (!columnVO.getFieldName().toUpperCase(Locale.ROOT).equals("ID")){
                xmlMapping +=
                        "\n <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName().toUpperCase() + "\" length=\"" + columnVO.getFieldLength() +
                                "\" column=\"" + columnVO.getFieldName().toUpperCase() + "\"/>\n";
//                }
            } catch (Exception e) {
                throw new ApiException("名称不合法！");
            }
        }

        xmlMapping += addDefaultTime(tableVO);
        xmlMapping += "   </class>\n" +
                "</hibernate-mapping>";
        return xmlMapping;
    }

    abstract String addGenerator(TableVO tableVO);

    abstract String addDefaultTime(TableVO tableVO);

}
