package com.tykj.user.authencation.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tykj.user.config.UserMap;
import com.tykj.user.pojo.UserDetail;
import com.tykj.user.service.StorageKeyService;
import com.tykj.user.service.UserAuthorityService;
import com.tykj.user.util.SpringContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author huangjiafu
 * @version V1.0
 * @data 2021/7/7 14:06
 **/
@Component
public class SuccessHandler implements AuthenticationSuccessHandler {
    @Autowired
    private UserAuthorityService userAuthorityService;

    static Map<String, Object> tokenMap = new HashMap<>();

    /**
     * 登陆成功后返回的数据
     * @param httpServletRequest
     * @param httpServletResponse
     * @param authentication
     * @throws IOException
     * @throws ServletException
     */
    @Override
    public void onAuthenticationSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Authentication authentication) throws IOException, ServletException {

        //注入jwtTokenUtils   不知道为啥@Autowired注入不进来
       // JwtTokenUtils jwtTokenUtils = (JwtTokenUtils) SpringContextHolder.getBean("jwtTokenUtils");
        StorageKeyService storageKeyService =  SpringContextHolder.getBean(StorageKeyService.class);
        UserAuthorityService userAuthorityService =  SpringContextHolder.getBean(UserAuthorityService.class);

        //获取用户
        UserDetail user = (UserDetail) authentication.getPrincipal();
        System.out.println("/////:"+user.toString());

        //获取用户APP权限id
        String appId = userAuthorityService.findAppByUserId(user.getId());
        //登录成功返回的map
        Map<String, Object> successMap = new HashMap<>();
        successMap.put("code", "200");
        successMap.put("userId", user.getId());
        successMap.put("username", user.getUsername());
        successMap.put("type",user.getType());
        successMap.put("clientIds",appId);
        //生成token时加入的map
        Map<String, Object> tokenMap = new HashMap<>();

        //真实姓名 身份证号
        tokenMap.put("username",user.getUsername());
        tokenMap.put("realName", user.getRealName());
        tokenMap.put("idCardNumber", user.getIdCardNumber());
        tokenMap.put("newDate",new Date());

        UserMap.userMap.put(user.getUsername(), new Date());

        //创建token
        //String token = jwtTokenUtils.createToken(tokenMap);
        String token = storageKeyService.generateUserToken(tokenMap);
        System.out.println("token:"+token);
        successMap.put("token", token);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("application/json; charset=utf-8");
        //返回前端
        httpServletResponse.getWriter().println(new ObjectMapper().writeValueAsString(successMap));
    }
}
