package com.tykj.user.config;

import com.tykj.user.dao.AuthorityDao;
import com.tykj.user.dao.StorageKeyDao;
import com.tykj.user.pojo.Authority;
import com.tykj.user.pojo.StorageKey;
import com.tykj.user.pojo.vo.Keys;
import com.tykj.user.util.CipherUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ApplicationRunnerImpl implements ApplicationRunner {
    @Autowired
    private StorageKeyDao storageKeyDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Override
    public void run(ApplicationArguments args) throws Exception {
        List<StorageKey> storageKeyList = storageKeyDao.findAll();
        if (storageKeyList.size() == 0){
            StorageKey storageKey = new StorageKey();
            //生成签名公私钥
            Keys signKeys = CipherUtil.generateKeys();
            storageKey.setSignPrivateKey(signKeys.getPrivateKey());
            storageKey.setSignPublicKey(signKeys.getPublicKey());
            //生成加密公私钥
            Keys rsaKeys = CipherUtil.generateKeys();
            storageKey.setRsaPrivateKey(rsaKeys.getPrivateKey());
            storageKey.setRsaPublicKey(rsaKeys.getPublicKey());
            storageKeyDao.save(storageKey);
        }
        assignAuthority();
    }

    public void assignAuthority(){
        List<Authority> authorityList = authorityDao.findByName("集成页面配置");
        if (authorityList == null){
            Authority authority1 = new Authority();
            authority1.setName("集成页面配置");
            authority1.setType(1);
            authorityDao.save(authority1);
        }

    }
}