package com.tykj.user.config;

import com.tykj.user.dao.OrganizationDao;
import com.tykj.user.dao.UserDao;
import com.tykj.user.pojo.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.Date;

@Component
public class AssignRole implements ApplicationRunner {
    @Autowired
    private OrganizationDao organizationDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    PasswordEncoder passwordEncoder;

    @Override
    public void run(ApplicationArguments args) throws Exception {
       //先检查是否管理员、安全员、审计员

        if (userDao.findByType(1) == null){
            User user = new User();
            creatRole(1,user);
            userDao.save(user);
        }

        if (userDao.findByType(2) == null){
            User user1 = new User();
            creatRole(2,user1);

            userDao.save(user1);
        }

        if (userDao.findByType(3) == null){
            User user2 = new User();
            creatRole(3,user2);
            userDao.save(user2);
        }
    }


    public void creatRole(Integer type,User user) {
        user.setType(type);
        switch (type) {
            case 1:
                user.setRealName("管理员");
                user.setUsername("管理员");
                user.setId("1");
                user.setCreateTime(new Date());
                user.setPassword(passwordEncoder.encode("qwer1234"));
                break;
            case 2:
                user.setRealName("安全员");
                user.setUsername("安全员");
                user.setId("2");
                user.setCreateTime(new Date());
                user.setPassword(passwordEncoder.encode("qwer1234"));
                break;
            case 3:
                user.setRealName("审计员");
                user.setUsername("审计员");
                user.setId("3");
                user.setCreateTime(new Date());
                user.setPassword(passwordEncoder.encode("qwer1234"));
                break;
        }
    }


}
