package com.tykj.user.controller;

import com.tykj.user.pojo.LogContent;
import com.tykj.user.pojo.vo.LogContentVo;
import com.tykj.user.pojo.vo.PageResponse;
import com.tykj.user.pojo.vo.ServerResponse;
import com.tykj.user.pojo.vo.uservo.LogVo;
import com.tykj.user.service.LogContentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/logContent")
@Api(tags = "日志管理")
public class LogContentController {

    @Autowired
    private LogContentService logContentService;

    @ApiOperation("根据id 查看日志详情")
    @PostMapping("/findById")
    public ServerResponse findById(@Validated @RequestBody LogVo logVo){
        LogContent logContent1 = logContentService.findById(logVo.getId());
        if (logContent1 != null){
            return ServerResponse.ok(logContent1);
        }
        return ServerResponse.error("未查到该日志信息");
    }

    @ApiOperation("查询日志列表")
    @PostMapping("/userList")
    public ServerResponse select(@Validated @RequestBody LogContentVo logContentVo){

        PageResponse<LogContent> logContentList = logContentService.select(logContentVo);
        if (logContentList != null){

            return ServerResponse.ok(logContentList);
        }
        return ServerResponse.error("未查到日志信息");
    }


}
