package com.tykj.user.controller;

import com.tykj.user.pojo.UserDetail;
import com.tykj.user.pojo.vo.ServerResponse;
import com.tykj.user.service.StorageKeyService;
import com.tykj.user.util.AuthenticationUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "Token管理")
@RestController
@RequestMapping("/storageKey")
public class StorageKeyController {
    @Autowired
    StorageKeyService storageKeyService;
    @Resource
    AuthenticationUtils authenticationUtils;

    @ApiOperation(value = "getKeys", notes = "获取rsaPrivateKey和signPublicKey", httpMethod = "POST")
    @PostMapping(value = "/getKeys")
    public ServerResponse getKeys(String applicationId){
        return ServerResponse.ok(storageKeyService.getKeys());
    }

    @ApiOperation(value = "getJwtToken", notes = "获取登录校验token", httpMethod = "GET")
    @GetMapping(value = "/getJwtToken")
    public ServerResponse getJwtToken(String appId){
        UserDetail authentication = authenticationUtils.getAuthentication();
        String token = storageKeyService.generateUserToken(authentication);
        return ServerResponse.ok(token);
    }



}
