package com.tykj.user.controller;

import com.google.common.collect.ImmutableMap;
import com.tykj.user.service.impl.SyncDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "数据同步")
@RequestMapping("/sync/data")
@RestController
public class SyncDataController {

    @Autowired
    private SyncDataService syncDataService;

    @ApiOperation("主动触发一次数据同步操作")
    @PostMapping("/execute")
    public ResponseEntity execute() {
        syncDataService.execute();
        return ResponseEntity.ok(ImmutableMap.of("msg", "同步完成"));
    }

}
