package com.tykj.user.controller;

import com.sun.istack.NotNull;
import com.tykj.user.pojo.Authority;
import com.tykj.user.pojo.LogContent;
import com.tykj.user.pojo.User;
import com.tykj.user.pojo.UserAuthority;
import com.tykj.user.pojo.vo.PageResponse;
import com.tykj.user.pojo.vo.ServerResponse;
import com.tykj.user.pojo.vo.uservo.*;
import com.tykj.user.service.AuthorityService;
import com.tykj.user.service.LogContentService;
import com.tykj.user.service.UserAuthorityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Controller
@RestController()
@RequestMapping("/userAuth")
@Api(tags = "用户权限管理")
public class UserAuthorityController {
    @Autowired
    private UserAuthorityService userAuthorityService;
    @Autowired
    private LogContentService logContentService;
    @Autowired
    private AuthorityService authorityService;

    @ApiOperation("根据用户id 查看用户权限")
    @PostMapping("/findUserAuthById")
    public ServerResponse findUserAuthById(@Validated @RequestBody UserAuthVo userAuthVo) {
        List<UserAuthority> authorityList = userAuthorityService.findByUid(userAuthVo.getId());
        if (authorityList != null) {
            return ServerResponse.ok(authorityList);
        }
        return ServerResponse.error("查询用户权限失败");

    }
/*

    @ApiOperation("为用户分配权限")
    @PostMapping("/addUserAuth")
    public ServerResponse addAuth(@Validated @RequestBody UserAuthLogVo userAuthLogVo){
        LogContent logContent = new LogContent();
        logContent.setOperator(userAuthLogVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("为用户分配权限");

        ArrayList<UserAuthority> userAuthorities = new ArrayList<>();

        List<String> uids = userAuthLogVo.getUids();
        Integer authId = userAuthLogVo.getAuthId();
        for (String uId : uids) {
            List<UserAuthority> userAuthorityList = userAuthorityService.findByUid(uId);

            //根据用户id 查找用户原有的权限id
            List<Integer> authIdList = userAuthorityService.findAuthByUid(uId);
            //如果用户之前没有该权限   新增用户权限
            if (!authIdList.contains(authId)){
                Authority authority = authorityService.findById(authId);
                UserAuthority userAuthority = new UserAuthority();
                userAuthority.setAuthorityId(authId);
                userAuthority.setUid(uId);
                userAuthority.setName(authority.getName());
                userAuthority.setType(authority.getType());
                userAuthorityList.add(userAuthorityService.save(userAuthority));
            }
            userAuthorities.addAll(userAuthorityList);

        }
        if (userAuthorities!= null){
            logContent.setResult("操作成功");
            logContentService.save(logContent);
            return ServerResponse.ok(userAuthorities);
        }

        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("分配权限失败");
    }
*/


    @ApiOperation("为用户分配权限")
    @PostMapping("/addUserAuth")
    public ServerResponse addAuth(@Validated @RequestBody UserAuthLogVo userAuthLogVo) {
        LogContent logContent = new LogContent();
        logContent.setOperator(userAuthLogVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("为用户分配权限");

        ArrayList<UserAuthsVo> orgAuthsVos = new ArrayList<>();
        List<String> uIds = userAuthLogVo.getUIds();
        for (String uId : uIds) {
            UserAuthsVo userAuthsVo = new UserAuthsVo();
            ArrayList<Integer> authList = new ArrayList<>();
            userAuthsVo.setUId(uId);
            List<UserAuthority> userAuthorityList = userAuthorityService.findByUid(uId);
            List<Integer> authIdList = userAuthorityService.findAuthByUid(uId);
            List<Integer> authIds = userAuthLogVo.getAuthIds();
            //先删除之前多余的
            for (Integer authId : authIdList) {
                if (!authIds.contains(authId)) {
                    //根据用户名和权限id 删除
                    UserAuthority userAuthority = userAuthorityService.findByUidAndAuthorityId(uId, authId);
                    userAuthorityList.remove(userAuthority);
                    userAuthorityService.delete(userAuthority);
                }
            }
            //新增权限
            for (Integer authId : authIds) {
                Authority authority = authorityService.findById(authId);
                UserAuthority userAuthority1 = userAuthorityService.findByUidAndAuthorityId(uId, authId);
                if (userAuthority1 == null && authority != null) {
                    UserAuthority userAuthority = new UserAuthority();
                    userAuthority.setAuthorityId(authId);
                    userAuthority.setUid(uId);
                    userAuthority.setName(authority.getName());
                    userAuthority.setType(authority.getType());
                    userAuthorityList.add(userAuthorityService.save(userAuthority));
                }
            }
            if (userAuthorityList != null) {
                logContent.setResult("操作成功");
                logContentService.save(logContent);
                return ServerResponse.ok(userAuthorityList);
            }
        }
        logContent.setResult("操作失败");
        logContentService.save(logContent);
        return ServerResponse.error("分配权限失败");
    }


    @ApiOperation("根据权限id 查看所有用户")
    @PostMapping("/findByAuthId")
    public ServerResponse findByAuthId(@Validated @RequestBody AuthUserVo authUserVo) {
        int page = authUserVo.getPage();
        int size = authUserVo.getSize();
        PageResponse<User> userList = userAuthorityService.findByAuthId(authUserVo.getId(), page, size);
        if (userList != null) {
            return ServerResponse.ok(userList);
        }
        return ServerResponse.error("未查到用户");

    }

    @ApiOperation("为用户删除某个权限")
    @DeleteMapping("/delete")
    public ServerResponse delete(@NotNull @RequestBody DelAuthUserVo delAuthUserVo) {
        LogContent logContent = new LogContent();
        logContent.setOperator(delAuthUserVo.getLoginer());
        logContent.setOperateTime(new Date());
        logContent.setContent("为用户删除权限");
        try {
            userAuthorityService.delete(delAuthUserVo.getAuthId(), delAuthUserVo.getUId());
        } catch (Exception e) {
            logContent.setResult("操作失败");
            logContentService.save(logContent);
            return ServerResponse.error("删除失败");
        }
        logContent.setResult("操作成功");
        logContentService.save(logContent);
        return ServerResponse.ok("删除成功");
    }


    @ApiOperation("为权限分配用户")
    @PostMapping("/addAuthUser")
    public ServerResponse addAuthUser(@Validated @RequestBody AuthUserLogVo authUserLogVo) {
        Integer authId = authUserLogVo.getAuthId();
        List<String> uIds = authUserLogVo.getUIds();
        List<UserAuthority> userAuthorities = new ArrayList<>();
        Authority authority = authorityService.findById(authId);

        //根据权限查出所有用户
        List<User> userList = userAuthorityService.findByAuthId(authId);
        System.out.println(userList.toArray());
        System.out.println(userList.size());
        //删除原来的用户权限  //4,5,6,14
        for (User user : userList) {

           if (user!=null && !uIds.contains(user.getId())) {
                UserAuthority userAuthority = userAuthorityService.findByUidAndAuthorityId(user.getId(), authId);
                userAuthorityService.delete(userAuthority);
            }
            if (user!=null && uIds.contains(user.getId())) {
                uIds.remove(user.getId());
                UserAuthority userAuthority = userAuthorityService.findByUidAndAuthorityId(user.getId(), authId);
                userAuthorities.add(userAuthority);
            }
        }
        //新添加的
        for (String uId : uIds) {
            UserAuthority userAuthority = new UserAuthority();
            userAuthority.setUid(uId);
            userAuthority.setAuthorityId(authId);
            userAuthority.setType(authority.getType());
            userAuthority.setName(authority.getName());
            userAuthority.setName(authority.getName());
            userAuthorityService.save(userAuthority);
            userAuthorities.add(userAuthority);
        }
        return ServerResponse.ok(userAuthorities);
    }
}
