package com.tykj.user.dao;

import com.tykj.user.pojo.AuthorityOrganization;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface AuthorityOrganizationDao extends JpaRepository<AuthorityOrganization, String >, JpaSpecificationExecutor<AuthorityOrganization> {

    List<AuthorityOrganization> findByOrgId(Integer orgId);

    AuthorityOrganization findByOrgIdAndAuthId(Integer orgId,Integer authId);

    List<AuthorityOrganization> findByAuthId(Integer authId);

    @Query(value = "select a from AuthorityOrganization a where a.authId=:authId ")
    Page<AuthorityOrganization> findByAuthIdPageable(@Param("authId") Integer authId, Pageable pageable);



}
