package com.tykj.user.pojo;

import org.springframework.beans.BeanUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.*;

/**
 * 描述: 用户类
 * 继承了SpringSecurity的UserDtails
 * 用于SpringSecurity框架的用户数据传输
 *
 * @author HuangXiahao
 * @version V1.0
 * @class UserDetailVo
 * @packageName com.example.personnelmanager.entity.vo
 * @data 2020/5/14
 **/
public class UserDetail extends User implements UserDetails {

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        //todo 权限列表
        List<GrantedAuthority> simpleGrantedAuthorities = new ArrayList<>();

        return simpleGrantedAuthorities;
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        //如果用户被标记删除则该用户不可用
        if (getDelStatus()==1){
            return true;
        }else {
            return false;
        }
    }

    public User toUser(){
        User user = new User();
        BeanUtils.copyProperties(this,user);
        return user;
    }

    //存在jwt中的数据
    public Map<String,Object> toMap(){
        Map<String, Object> userInfoMap = new HashMap<>();
        userInfoMap.put("type","user");
        userInfoMap.put("id",getId());
        userInfoMap.put("username", getUsername());
        userInfoMap.put("realName", getRealName());
        userInfoMap.put("idCardNumber", getIdCardNumber());
        userInfoMap.put("phone", getPhone());
        userInfoMap.put("sex", getSex());
        userInfoMap.put("organizationCode", getOrganizationCode());
        return userInfoMap;
    }
}
