package com.tykj.user.pojo.vo;


import com.tykj.user.pojo.vo.uservo.OrgVo;

import java.util.ArrayList;
import java.util.List;

public class OrganizationTree {
    private List<OrgVo> orgList = new ArrayList<OrgVo>();
    public OrganizationTree(List<OrgVo> orgList) {
        this.orgList=orgList;
    }

    //建立树形结构
    public List<OrgVo> builTree(){
        List<OrgVo> treeorgs =new  ArrayList<OrgVo>();
        for(OrgVo orgNode : getRootNode()) {
            orgNode=buildChilTree(orgNode);
            treeorgs.add(orgNode);
        }
        return treeorgs;
    }

    //递归，建立子树形结构
    private OrgVo buildChilTree(OrgVo pNode){
        List<OrgVo> chilOrgs =new  ArrayList<OrgVo>();
        for(OrgVo orgNode : orgList) {
            if(orgNode.getPid().equals(pNode.getId())) {
                chilOrgs.add(buildChilTree(orgNode));
            }
        }
        pNode.setChildren(chilOrgs);
        return pNode;
    }

    //获取根节点
    private List<OrgVo> getRootNode() {
        List<OrgVo> rootOrgLists =new  ArrayList<OrgVo>();
        for(OrgVo orgNode : orgList) {
            if(orgNode.getPid().equals("0")) {
                rootOrgLists.add(orgNode);
            }
        }
        return rootOrgLists;
    }
}