package com.tykj.user.service;

import com.tykj.user.pojo.Authority;
import com.tykj.user.pojo.AuthorityOrganization;
import com.tykj.user.pojo.Organization;
import com.tykj.user.pojo.vo.PageResponse;

import java.util.List;
import java.util.Set;

public interface AuthorityOrganizationService {


    AuthorityOrganization findById(Integer id);

    /**
     * 根据组织架构id 查找该组织架构的权限列表
     * @param orgId
     * @return
     */
    List<Authority> findByOrgId(Integer orgId);

    List<AuthorityOrganization> findAllByOrgId(Integer orgId);


    Set<Integer> findAuthidsByOrgId(Integer orgId);

    AuthorityOrganization findByOrgIdAndAuthId(Integer orgId,Integer authId);

    PageResponse<Organization> findByAuthId(Integer authId, int page, int size);

    void delete(Integer orgId,Integer authId);

    List<AuthorityOrganization> findByAuthId(Integer authId);


    AuthorityOrganization save(AuthorityOrganization authorityOrganization);





}
