package com.tykj.user.service;


import com.tykj.user.pojo.Organization;
import com.tykj.user.pojo.vo.OrganizationVo;

import java.util.List;

public interface OrganizationService {
    List<Organization> findAll();

    /**
     * 新增组织架构
     * @param organization 组织架构
     * @return
     */
    Organization add(Organization organization);


    /**
     * 修改组织架构
     * @param organization
     * @return
     */
    Organization update(Organization organization);


    /**
     * 根据id删除组织架构
     * @param id
     */
    void delete(Integer id);

    /**
     * 根据id查找组织架构
     * @param id
     * @return
     */
    Organization findById(Integer id);

    /**
     * 查询组织架构
     * @return
     */
    List<OrganizationVo> find(List<Organization> organizationList);

    List<Organization> findByOrganizationNameLike(String organizationName);

    List<Organization> findByCode(String code);

    /**
     * 根据组织code 查出组织code对应的组织已经组织上级的parent
     * @param code
     * @return
     */
    List<Organization> findOrganizationListById(Integer id);


}
