package com.tykj.user.service.impl;

import com.github.wenhao.jpa.Specifications;
import com.tykj.user.dao.AuthorityDao;
import com.tykj.user.dao.AuthorityOrganizationDao;
import com.tykj.user.dao.OrganizationDao;
import com.tykj.user.pojo.Authority;
import com.tykj.user.pojo.AuthorityOrganization;
import com.tykj.user.pojo.Organization;
import com.tykj.user.pojo.vo.PageResponse;
import com.tykj.user.service.AuthorityOrganizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service
public class AuthorityOrganizationServiceImpl implements AuthorityOrganizationService {
    @Autowired
    private AuthorityOrganizationDao authorityOrganizationDao;
    @Autowired
    private AuthorityDao authorityDao;
    @Autowired
    private OrganizationDao organizationDao;
    @Override
    public AuthorityOrganization findById(Integer id) {
        return null;
    }

    @Override
    public List<Authority> findByOrgId(Integer orgId) {
        List<AuthorityOrganization> authorityOrganizations = authorityOrganizationDao.findByOrgId(orgId);
        List authorityList = new ArrayList<Authority>();
        if (authorityOrganizations!=null){
            for (AuthorityOrganization authorityOrganization : authorityOrganizations) {
                Integer authId = authorityOrganization.getAuthId();
                Authority authority = authorityDao.findById(authId).get();
                authorityList.add(authority);
            }
            return authorityList;
        }
        return null;
    }

    @Override
    public List<AuthorityOrganization> findAllByOrgId(Integer orgId) {
        List<AuthorityOrganization> authorityOrganizations = authorityOrganizationDao.findByOrgId(orgId);
        if (authorityOrganizations!=null){
            return authorityOrganizations;
        }
        return null;
    }


    @Override
    public Set<Integer> findAuthidsByOrgId(Integer orgId) {
        HashSet<Integer> authorityIds = new HashSet<>();
        List<Authority> authorityList = findByOrgId(orgId);
        if (authorityList!=null) {
            for (Authority authority : authorityList) {
                authorityIds.add(authority.getAppId());
            }
            return authorityIds;
        }
        return null;
    }

    @Override
    public AuthorityOrganization findByOrgIdAndAuthId(Integer orgId, Integer authId) {
        AuthorityOrganization authorityOrganization = authorityOrganizationDao.findByOrgIdAndAuthId(orgId, authId);
        if (authorityOrganization != null){
            return authorityOrganization;
        }
        return null;
    }


    @Override
    public PageResponse<Organization> findByAuthId(Integer authId, int page, int size){
        List<AuthorityOrganization> authorityOrganizationList = authorityOrganizationDao.findByAuthId(authId);
        List<Integer> organizationIdList = new ArrayList<>();
        for (AuthorityOrganization authorityOrganization : authorityOrganizationList) {
            organizationIdList.add(authorityOrganization.getOrgId());
        }
        Integer[] integers = organizationIdList.toArray(new Integer[0]);
        Specification<Organization> specification = Specifications.<Organization>and()
                .in(organizationIdList!=null,"id",integers)
                .build();
        if (page <= 0) {
            page = 1;
        }
        Pageable pageable = PageRequest.of(page - 1, size);
        List<Organization> organizations = organizationDao.findAll(specification, pageable).getContent();
        long count = organizationDao.count(specification);
        return new PageResponse<>(page, size, count, organizations);


        /*if (authorityOrganizationList!= null){
            for (AuthorityOrganization authorityOrganization : authorityOrganizationList) {
                if (authorityOrganization!=null && authorityOrganization.getAuthId()!=null){
                    Organization organization = organizationDao.findById(authorityOrganization.getOrgId()).get();
                    organizationList.add(organization);
                }
            }
        }*/


    }


    @Override
    public void delete(Integer orgId, Integer authId) {
        AuthorityOrganization authorityOrganization = authorityOrganizationDao.findByOrgIdAndAuthId(orgId, authId);
        if (authorityOrganization!=null){
            authorityOrganizationDao.delete(authorityOrganization);
        }
    }


    @Override
    public List<AuthorityOrganization> findByAuthId(Integer authId) {
        List<AuthorityOrganization> authorityOrganizationList = authorityOrganizationDao.findByAuthId(authId);
        if (authorityOrganizationList != null){
            return authorityOrganizationList;
        }
        return null;
    }

    @Override
    public AuthorityOrganization save(AuthorityOrganization authorityOrganization) {
        AuthorityOrganization authorityOrganization1 = authorityOrganizationDao.save(authorityOrganization);

        return authorityOrganization1;
    }
}
