package com.tykj.user.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.joda.time.DateTime;

import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

/**
 * @author HuangXiahao
 * @version V1.0
 * @class jwtUtil
 * @packageName com.tykj.support.misc.util
 *
 **/
public class JwtUtil {
    private static final String AUTHORITIES_KEY = "MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQC/HJueEYuj1TlqDK75eFDujMXgKvMli+rqyAIS7PkMMwhOp3DDqy+wU46MbY4CUuCVynQkQDOnSDwwd3xyqln2w95sXmVooWNNLJAtdH81WtJ649KGG2X1W/K3O47s7Zms8Cy4erCEWOMnm/B8EqnHxragllql2cRAd1OJzGdxumhQXDGnDAnvQ693NW+ARhRxIP/BqUXFItNc9x+Q8Lsi6I70ZCj8jeh7C76KCoq+n+MZQqF8m9xTKyKl/w5sJWKUBXxClyWHOz9/dLQOiMgxc0n/bbGwuwq56EwW+uL+VHRt1huoKY5mM8Z8qHnhKqLizB+8SEQZThp5XXe9iSyVAgMBAAECggEAfaJF3wzzunkyrDe4U0G4GooqjupNO5KWlU90pZJpSo7F2EcUx1zjFcxoOoLOx1JKV85muWoHSuIex1HVWuAIEkPDFYScr8Lgr9wqz+b0tVOGaMkaHZUnWrvefHxHwhOUYe7lx0TIg8iXU/OcjUQLnsxQRJNy9fKJpEONhFn+avEXwg45oUD129NIKIGWFvZyHPgBdT4w0P6OpX0f+jwWCYA9beXTMOQMybu2XFLYj2zwexuPTmqPGoTvOf79kAUjAs3KTbOXdz4I0bpeZoO47KpeRuIO3zHuNkLvoYD2gX1cYlr6Qf6W9OUKGTbKkHpTF88ZJCgqPL+GMDPKJnqZpQKBgQDrOnd1Tw8wHyQKDun2m0o0815GS7IMyslgr7hXzPzkrBT8+PJZ5cK0DX+O/lkxmMuHP9K+N9+rLQcjPDSxoVlW5uMbvtjgeZRoAY00GKBvZ4IdjynIYHKY/iU7BV6zLQ88QUSPtH4fdTR86Ud1fnEzkepErVWtGoQGIkxV0xeUzwKBgQDP/NkV1WcCoUahvhA9GL9gemcXDVQvYuu4BRNY677tq5J1QHEYak0tLhDn9kL7W3oftDdMqYfHwUNCmyM9aAfVglvfEJfuS35H+0kk73vKG1WI3XpDtUHDVYRLu1KQq3A3dPCvyEmzBzJV2C6o6yXX9EBAO0wJ5AKWo2j9NFQJWwKBgQDCXWUnwVPDZ3fX98rKwjXm2tEjNJjCiS0sfwXLRs4QBUCyZuGZ9oeTTzP/a5s3qBFEiDASjQh74JDtRGol/DRd4hn2axO5J7zA08dhLJgkdVrGIe1cbJVEZXtN8Xn2g1z7ZNLKC1HLnITqUbeCFiBjhEYWyULp7eb5So3YvLvXcQKBgQCmuyJnr1hRsmnF1XB9Ge6o79beku/OwPUH4wG8gdff/W9+ETfYg7b0pf4lhbPyfkWrTrQZ/7l6d8JsjaM1YcUN8t+lNU8mV1yXZakgM98/iKQMAMg3qQFcDpzsfPFWSii+PD+KGvyByR4f1RqqjT8cHJC5LQ/qyd8NVVgfyygnCwKBgQCGSHlpWaFpGk+BSiuXhtyqCfFt/pBGS1iWGxqJBecG0OJP0agVI5UHPQbfD2e5RcsKDBns8mBbsDex8yUJ8pjMlzN2IfKE16V0syOpVrHFZFA+rKc6QTtd+C5VGPSX0RMPYud3wBjd8Pow/LY6YsI7PtgYP5qbNmf+Rte3jwGPBg==";

    public static String generateToken(Map<String, Object> payloadMap, int expireMinutes, PrivateKey privateKey) {
        return Jwts.builder()
                .setClaims(payloadMap)
                .setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate())
                .signWith(SignatureAlgorithm.RS256, privateKey)
                .compact();
    }

    public static String generateToken(Claims claims, int expireMinutes, PrivateKey privateKey) {
        return Jwts.builder()
                .setClaims(claims)
                .setExpiration(DateTime.now().plusMinutes(expireMinutes).toDate())
                .signWith(SignatureAlgorithm.RS256, privateKey)
                .compact();
    }

    public static void main(String[] args) {
        Map<String, Object> map = new HashMap<>();
        map.put("user","admin");
        String s = generateToken(map, 60, CipherUtil.string2PrivateKey(AUTHORITIES_KEY));
        System.out.println(s);
    }

}
