package com.tykj.datawarehouse.model.controller;

import com.tykj.datawarehouse.base.result.ResultUtil;
import com.tykj.datawarehouse.model.dao.ColumnInfoDao;
import com.tykj.datawarehouse.model.entity.Quote;
import com.tykj.datawarehouse.model.entity.vo.SearchQuoteVO;
import com.tykj.datawarehouse.model.entity.vo.UpdateQuoteVO;
import com.tykj.datawarehouse.model.service.QuoteService;
import com.tykj.datawarehouse.model.service.impl.ModelImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;


/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/5/17 15:57
 */

@Api(tags = "引用接口")
@RestController
@RequestMapping("/quote")
public class QuoteController {
    @Autowired
    private QuoteService quoteService;

    @ApiOperation("引用删除")
    @GetMapping("/delete")
    public ResponseEntity deleteQuote(Integer id) {
        return ResultUtil.success(quoteService.delQuote(id), "删除成功！");
    }

    @ApiOperation("引用更新")
    @PostMapping("/update")
    public ResponseEntity UpdateQuote(@RequestBody UpdateQuoteVO updateQuoteVO) {
        return ResultUtil.success(quoteService.updateQuote(updateQuoteVO), "更新成功！");
    }

    @ApiOperation("查找所有引用")
    @PostMapping("/getAllQuote")
    public ResponseEntity getAllQuote(@RequestBody SearchQuoteVO searchQuoteVO) {
        return ResultUtil.success(quoteService.getAllQuote(searchQuoteVO), "查询成功！");
    }
    @ApiOperation("保存引用")
    @PostMapping("/saveQuote")
    public ResponseEntity saveQuote(@RequestBody Quote quote) {
        return ResultUtil.success(quoteService.saveQuote(quote) ,"保存成功！");
    }

}
