package com.tykj.datawarehouse.model.entity.vo;

import com.tykj.datawarehouse.model.entity.Quote;
import com.tykj.datawarehouse.model.entity.Rule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName ColumnVO
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 9:58
 * @Version 1.0
 */
@ApiModel("列信息VO")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ColumnVO {

    @ApiModelProperty("id")
    private Integer id;
    @ApiModelProperty("是否主键")
    private Integer primaryKey = 1;
    @ApiModelProperty("字段类型")
    private String fieldType;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("中文描述")
    private String fieldTitle;
    @ApiModelProperty("字段长度，有默认值")
    private Integer fieldLength;
    @ApiModelProperty("规则")
    private Rule rule;
    @ApiModelProperty("详细描述")
    private String description;
    @ApiModelProperty("引用数组")
    private List<Quote> quoteList;

}
