package com.tykj.datawarehouse.model.service;


import com.tykj.datawarehouse.model.entity.ColumnInfo;
import com.tykj.datawarehouse.model.entity.TableInfo;
import com.tykj.datawarehouse.model.entity.vo.*;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

/**
 * @ClassName ModelService
 * @Description TODO
 * @Author WWW
 * @Date 2021/2/26 13:36
 * @Version 1.0
 */
public interface ModelService {

    /**
     * 分页查询
     *
     * @param searchTableInfoVo
     * @return
     */
    Page<TableInfo> pageAllEntities(SearchTableInfoVo searchTableInfoVo);


    /**
     * 方法重载不分页查询
     *
     * @return
     */
    List<TableInfo> listAllEntities(SearchTableInfoVo searchTableInfoVo);


    /**
     * 根据表名查询所有字段信息
     *
     * @param searchColumnInfoVo
     * @return
     */
    List<ColumnInfo> showModelFields(SearchColumnInfoVo searchColumnInfoVo);


    /**
     * 新建模型
     *
     * @param tableVO
     * @return
     */

    TableInfo newTable(TableVO tableVO);

    /**
     *
     *根据表名插入数据
     * @param map
     * @return
     */
    int putValueByEntityName(Map<String, Object> map,Boolean isDelete);

    /**
     * 插入一组数据
     * @param mapList
     * @return
     */
    int putValueByEntityNameList(List<Map<String, Object>> mapList,Boolean isDelete);

    /**
     * 根据表名查询所有
     *
     * @param name
     * @return
     * @throws SQLException
     */
    List<Map<String, Object>> findAllByName(String name) throws SQLException;


    /**
     * 复杂查询
     *
     * @param tableName
     * @param queryConditions
     * @return
     */
    List<Map<String, Object>> complexQuery(String tableName, List<String> columnNames, List<QueryCondition> queryConditions,String groupName);

    /**
     * 复杂查询（带分类）
     *
     * @param tableName
     * @param queryConditions
     * @return
     */
    CustomPage complexQueryWithGroup(String tableName, GroupCondition groupCondition, List<String>columnNames, List<QueryCondition> queryConditions, String groupByColumn, Integer page, Integer size);


    /**
     * 修改表
     *
     * @param updateTableInfoVO
     * @return
     */
    int updateTable(UpdateTableInfoVO updateTableInfoVO);


    /**
     * 删除表
     *
     * @param delTableVO
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    int delTable(DelTableVO delTableVO);


    /**
     * 根据id批量查询所有tableInfo和ColumnInfo
     *
     * @param ids
     * @return
     */
    TableAndColumnInfoVO getTableInfoAndColumnInfoByBatch(Integer[] ids);

    /**
     * 执行自定义SQL
     * @param sql
     * @return
     * @throws SQLException
     */
    List<Map<String, Object>> executeQuery(String sql) throws SQLException;

}
