package com.tykj.datawarehouse.model.utils;


import com.tykj.datawarehouse.base.result.ApiException;
import com.tykj.datawarehouse.model.entity.vo.ColumnVO;
import com.tykj.datawarehouse.model.entity.vo.TableVO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName CreateTableUtil
 * @Description TODO
 * @Author WWW
 * @Date 2021/3/1 14:35
 * @Version 1.0
 */
public class CreateTableUtil {

    private static final Map<String, String> TYPE_MAP = new HashMap<>();

    static {
        TYPE_MAP.put("java.lang.Integer", "java.lang.Integer");
        TYPE_MAP.put("java.lang.Long", "java.lang.Long");
        TYPE_MAP.put("java.lang.Short", "java.lang.Short");
        TYPE_MAP.put("java.lang.Float", "java.lang.Float");
        TYPE_MAP.put("java.lang.Double", "java.lang.Double");
        TYPE_MAP.put("java.lang.BigDecimal", "java.lang.BigDecimal");
        TYPE_MAP.put("java.lang.String", "java.lang.String");
        TYPE_MAP.put("java.lang.Byte", "java.lang.Byte");
        TYPE_MAP.put("java.lang.Boolean", "java.lang.Boolean");
        TYPE_MAP.put("java.lang.Class", "java.lang.String");
        TYPE_MAP.put("java.util.Date", "java.util.Date");
        TYPE_MAP.put("java.util.Calendar", "java.util.Calendar");
        TYPE_MAP.put("java.util.Locale", "java.util.String");
        TYPE_MAP.put("java.util.TimeZone", "java.util.String");
        TYPE_MAP.put("java.util.Currency", "java.util.String");
        TYPE_MAP.put("java.sql.Date", "java.sql.Date");
        TYPE_MAP.put("java.sql.Time", "java.sql.Time");
        TYPE_MAP.put("java.sql.Timestamp", "java.sql.Timestamp");
        TYPE_MAP.put("java.sql.Clob", "java.sql.Clob");
        TYPE_MAP.put("java.sql.Blob", "java.sql.Blob");
        TYPE_MAP.put("java.lang.Object", "java.lang.String");
        TYPE_MAP.put("java.util.Map", "java.lang.String");

    }


    public static String createTable(TableVO tableVO) {
        //   1sql-type="text" string 转为text文本，2长度超过会自动转换
        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + tableVO.getModelName().toLowerCase().toUpperCase() + "\" table=\"" + tableVO.getModelName().toLowerCase().toUpperCase() + "\">\n";

        xmlMapping += " <id name=\"id\" type=\"java.lang.Integer\" length=\"11\" unsaved-value=\"null\"  >\n" +
                "  <generator  class=\"com.tykj.datawarehouse.base.entity.XMQGenerator\"  >\n" +
                "<param name=\"sequence\">SEQUENCE_" + tableVO.getModelName().toLowerCase().toUpperCase() + "</param>" +
                "</generator>" +
                "        </id>\n";


        for (ColumnVO columnVO : dataList) {
            try {
                xmlMapping +=
                        "\n <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName().toUpperCase() + "\" length=\"" + columnVO.getFieldLength() +
                                "\" column=\"" + columnVO.getFieldName().toUpperCase() + "\"/>\n";

            } catch (Exception e) {
                throw new ApiException("名称不合法！");
            }
        }

//        xmlMapping+=" <property name =\"CREATE_TIME\" type =\"calendar\" generated=\"always\"   insert=\"false\" update=\"false\" access=\"field\" >" +
//                "<column name=\"CREATE_TIME\" not-null=\"true\" default=\"CURRENT_TIMESTAMP\" />\n"+
//                "</property> " ;
//
//        xmlMapping+=" <property name =\"UPDATE_TIME\" type =\"calendar\" generated=\"always\"  insert=\"false\" update=\"false\" access=\"field\" >" +
//                "<column name=\"UPDATE_TIME\" not-null=\"true\" default=\"CURRENT_TIMESTAMP\" />\n"+
//                "</property> " ;
        ;
        xmlMapping += "  <property name = \"CREATE_TIME\" type =\"java.util.Date\"  generated=\"always\"  >    \n" +
                "            <column name = \"CREATE_TIME\"  default = \"CURRENT_TIMESTAMP\" />    \n" +
                "        </property>  \n" +
                "       <property name = \"UPDATE_TIME\" type =\"java.util.Date\"  >    \n" +
                "            <column name = \"UPDATE_TIME\"  default = \"CURRENT_TIMESTAMP\" />    \n" +
                "        </property>  ";
        xmlMapping += "   </class>\n" +
                "</hibernate-mapping>";
        return xmlMapping;
    }


    public static String createTable(String entityName, ColumnVO primaryColumn, List<ColumnVO> dataList) {
        //   1sql-type="text" string 转为text文本，2长度超过会自动转换
//        List<ColumnVO> dataList = tableVO.getDataList();
        String xmlMapping = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<!DOCTYPE hibernate-mapping PUBLIC\n" +
                "        \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n" +
                "        \"http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd\">\n" +
                "<hibernate-mapping>\n" +
                "    <class entity-name=\"" + entityName + "\" table=\"" + entityName + "\">\n";

        xmlMapping += " <id name=\"" + primaryColumn.getFieldName() + "\" type=\"" + primaryColumn.getFieldType() + "\" unsaved-value=\"null\"  >\n" +
                "        </id>";


        for (ColumnVO columnVO : dataList) {

//            xmlMapping +=
//                    "\n <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName() +
//                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";

            xmlMapping +=
                    "\n <property type=\"" + columnVO.getFieldType() + "\" name=\"" + columnVO.getFieldName() + "\" length=\"" + columnVO.getFieldLength() +
                            "\" column=\"" + columnVO.getFieldName() + "\"/>\n";
        }

        xmlMapping += "        <property name=\"createTime\" column=\"CREATETIME\" type=\"calendar\" insert=\"false\"   \n" +
                "            update=\"false\" access=\"field\" generated=\"always\" default=\"CURRENT_TIMESTAMP\"/>    \n" +
                "        <property name=\"updateTime\" column=\"UPDATETIME\" type=\"calendar\" insert=\"false\"   \n" +
                "            update=\"false\" access=\"field\" generated=\"always\"  default=\"CURRENT_TIMESTAMP\" />     ";
        xmlMapping += "   </class>\n" +
                "</hibernate-mapping>";
        return xmlMapping;
    }



    /**
     *小写
     */
    String lowerCaseReg = "^[a-z]+$";

    /**
     *大写
     */
    String upperCaseReg = "^[A-Z]+$";

}
