package com.tykj.datawarehouse.model.controller;

import com.tykj.datawarehouse.base.result.ResultUtil;
import com.tykj.datawarehouse.model.entity.vo.RuleVo;
import com.tykj.datawarehouse.model.service.RuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/6/29 16:39
 */
@Api(tags = "规则接口")
@RestController
@RequestMapping("/rule")
public class RuleController {

    @Autowired
    RuleService ruleService;

    @ApiModelProperty("规则删除")
    @GetMapping("/delete")
    public ResponseEntity deleteRule(Integer id) {
        try {
            ruleService.del(id);
            return ResultUtil.success("删除成功！");
        } catch (Exception e) {

        }
        return ResultUtil.failed("删除失败！");
    }

    @ApiModelProperty("规则新增")
    @PostMapping("/save")
    public ResponseEntity add(@RequestBody RuleVo ruleVo) {
        try {
            ruleService.add(ruleVo);
            return ResultUtil.success("保存成功！");
        } catch (Exception e) {

        }
        return ResultUtil.failed("保存失败！");
    }

    @ApiModelProperty("规则修改")
    @PostMapping("/update")
    public ResponseEntity update(@RequestBody RuleVo ruleVo) {
        try {
            ruleService.add(ruleVo);
            return ResultUtil.success("修改成功！");
        } catch (Exception ignored) {

        }
        return ResultUtil.failed("修改失败！");
    }

    @ApiModelProperty("规则修改")
    @PostMapping("/getAll")
    public ResponseEntity get() {

        return ResultUtil.success(ruleService.getAll(), "查询成功");
    }
}
