package com.tykj.datawarehouse.model.service.impl;

import com.tykj.datawarehouse.model.dao.RuleDao;
import com.tykj.datawarehouse.model.entity.Rule;
import com.tykj.datawarehouse.model.entity.vo.RuleVo;
import com.tykj.datawarehouse.model.service.RuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @Description TODO
 * @Author WWW
 * @Date 2021/6/29 11:05
 */
@Service
public class RuleServiceImpl implements RuleService {

    @Autowired
    RuleDao ruleDao;

    /**
     * @param ruleVo
     */
    @Override
    public void add(RuleVo ruleVo) {
        Rule rule = new Rule(
                ruleVo.getTableId(),
                ruleVo.getColumnId(),
                ruleVo.getRegular()
        );
        ruleDao.save(rule);
    }


    /**
     * 修改
     *
     * @param ruleVo
     */
    @Override
    public void update(RuleVo ruleVo) {
        Rule rule = new Rule();
        rule.setId(ruleVo.getId());
        rule.setColumnId(ruleVo.getColumnId());
        rule.setRegular(ruleVo.getRegular());
        rule.setTableId(ruleVo.getTableId());
        rule.setUpdatedTime(new Date());

        ruleDao.save(rule);
    }

    /**
     * 删除
     *
     * @param id
     */
    @Override
    public void del(Integer id) {
        ruleDao.deleteById(id);
    }

    /**
     * 查询
     *
     * @return
     */
    @Override
    public List<Rule> getAll() {
        return ruleDao.findAll();
    }
}
